# coding=utf-8
__all__ = ['get_itemwiki', 'get_tag']

from datetime import datetime, timedelta
from .es import tzlc
from gm_types.gaia import TAG_V3_TYPE
from agile.services.tag import get_tag_v3_attr_by_tag_v3_ids_by_url, gets_synonym_homoionym_by_ids_names, \
    gets_nomal_dict

MIN_TIME = tzlc(datetime.utcfromtimestamp(0))
MAX_TIME = tzlc(datetime.utcfromtimestamp(2147483647))


def get_tag(instance):
    t = instance
    res = {
        'id': t.id,
        'name': t.name,
        'is_online': t.is_online,
        'description': t.description,

    }
    return res


def get_tagv3(instance):
    t = instance
    res = {
        'id': t.id,
        'name': t.name,
        'is_online': t.is_online,
        'homoionym': t.homoionym,
        'tag_type': t.tag_type
    }
    ##g根据tag_type的类型判断
    if t.tag_type == TAG_V3_TYPE.FIRST_CLASSIFY:  # 一级分类
        second_classify_tags = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                    tag_type=TAG_V3_TYPE.FIRST_CLASSIFY,
                                                                    agg_type=TAG_V3_TYPE.SECOND_CLASSIFY, get_name=True)
        second_classify_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                   tag_type=TAG_V3_TYPE.FIRST_CLASSIFY,
                                                                   agg_type=TAG_V3_TYPE.SECOND_CLASSIFY, get_name=False)

        res['second_classify_ids'] = second_classify_ids
        res['second_classify_names'] = second_classify_tags

        project_tags_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                  tag_type=TAG_V3_TYPE.FIRST_CLASSIFY,
                                                                  agg_type=TAG_V3_TYPE.NORMAL, get_name=True)
        project_tags_id = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                               tag_type=TAG_V3_TYPE.FIRST_CLASSIFY,
                                                               agg_type=TAG_V3_TYPE.NORMAL, get_name=False)

        res['second_classify_ids'] = project_tags_id
        res['second_classify_names'] = project_tags_names

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.FIRST_CLASSIFY)
    elif t.tag_type == TAG_V3_TYPE.SECOND_CLASSIFY:  # 二级分类
        project_tags_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                  agg_type=TAG_V3_TYPE.NORMAL,
                                                                  tag_type=TAG_V3_TYPE.SECOND_CLASSIFY, get_name=True)
        project_tags_id = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                               agg_type=TAG_V3_TYPE.NORMAL,
                                                               tag_type=TAG_V3_TYPE.SECOND_CLASSIFY, get_name=False)

        res['project_tags'] = project_tags_names
        res['project_tags_ids'] = project_tags_id
        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.SECOND_CLASSIFY)
    elif t.tag_type == TAG_V3_TYPE.NORMAL:  # 项目标签
        ###获取ID
        all_tag_dict = gets_nomal_dict(tag_type=TAG_V3_TYPE.NORMAL, tags_ids=[t.id])
        res['first_classify_ids'] = all_tag_dict.get("first_classify_ids", [])
        res['second_classify_ids'] = all_tag_dict.get("second_classify_ids", [])
        res['first_demands_ids'] = all_tag_dict.get("first_demands_ids", [])
        res['second_demands_ids'] = all_tag_dict.get("second_demands_ids", [])
        res['first_solutions_ids'] = all_tag_dict.get("first_solutions_ids", [])
        res['second_solutions_ids'] = all_tag_dict.get("second_solutions_ids", [])
        res['first_positions_ids'] = all_tag_dict.get("first_positions_ids", [])
        res['second_positions_ids'] = all_tag_dict.get("second_positions_ids", [])
        ###获取名称
        res['first_classify_names'] = all_tag_dict.get("first_classify_names", [])
        res['second_classify_names'] = all_tag_dict.get("second_classify_names", [])
        res['first_demands'] = all_tag_dict.get("first_demands", [])
        res['second_demands'] = all_tag_dict.get("second_demands", [])
        res['first_solutions'] = all_tag_dict.get("first_solutions", [])
        res['second_solutions'] = all_tag_dict.get("second_solutions", [])
        res['first_positions'] = all_tag_dict.get("first_positions", [])
        res['second_positions'] = all_tag_dict.get("second_positions", [])

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.NORMAL)

    elif t.tag_type == TAG_V3_TYPE.FIRST_APPEAL:  # 一级诉求
        second_demands = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                              agg_type=TAG_V3_TYPE.SECOND_APPEAL,
                                                              tag_type=TAG_V3_TYPE.FIRST_APPEAL, get_name=True)
        second_demands_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                  agg_type=TAG_V3_TYPE.SECOND_APPEAL,
                                                                  tag_type=TAG_V3_TYPE.FIRST_APPEAL, get_name=False)
        res['second_demands'] = second_demands
        res['second_demands_ids'] = second_demands_ids

        project_tags_name = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=second_demands_ids,
                                                                 agg_type=TAG_V3_TYPE.NORMAL,
                                                                 tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=True)
        project_tags_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=second_demands_ids,
                                                                agg_type=TAG_V3_TYPE.NORMAL,
                                                                tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=False)
        res['project_tags_ids'] = project_tags_ids
        res['project_tags'] = project_tags_name

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.FIRST_APPEAL)
    elif t.tag_type == TAG_V3_TYPE.SECOND_APPEAL:  # 二级诉求
        first_demands_name = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                  agg_type=TAG_V3_TYPE.FIRST_APPEAL,
                                                                  tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=True)
        first_demands_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                 agg_type=TAG_V3_TYPE.FIRST_APPEAL,
                                                                 tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=False)
        res['first_demands'] = first_demands_name
        res['first_demands_ids'] = first_demands_ids

        project_tags_name = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                 agg_type=TAG_V3_TYPE.NORMAL,
                                                                 tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=True)
        project_tags_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                agg_type=TAG_V3_TYPE.NORMAL,
                                                                tag_type=TAG_V3_TYPE.SECOND_APPEAL, get_name=False)
        res['project_tags_ids'] = project_tags_ids
        res['project_tags'] = project_tags_name

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.SECOND_APPEAL)

    elif t.tag_type == TAG_V3_TYPE.MACROSCOPIC_MODE:  # 一级方式
        second_solutions = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                agg_type=TAG_V3_TYPE.FIRST_BRAND,
                                                                tag_type=TAG_V3_TYPE.MACROSCOPIC_MODE, get_name=True)
        second_solutions_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                    agg_type=TAG_V3_TYPE.FIRST_BRAND,
                                                                    tag_type=TAG_V3_TYPE.MACROSCOPIC_MODE,
                                                                    get_name=False)
        res['second_solutions'] = second_solutions
        res['second_solutions_ids'] = second_solutions_ids

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.MACROSCOPIC_MODE)

    elif t.tag_type == TAG_V3_TYPE.FIRST_BRAND:  # 二级方式
        first_solutions = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                               agg_type=TAG_V3_TYPE.MACROSCOPIC_MODE,
                                                               tag_type=TAG_V3_TYPE.FIRST_BRAND, get_name=True)
        first_solutions_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                   agg_type=TAG_V3_TYPE.MACROSCOPIC_MODE,
                                                                   tag_type=TAG_V3_TYPE.FIRST_BRAND, get_name=False)
        res['first_solutions'] = first_solutions
        res['first_solutions_ids'] = first_solutions_ids

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.FIRST_BRAND)
    elif t.tag_type == TAG_V3_TYPE.FIRST_POSITION:  # 一级部位
        second_positions = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                agg_type=TAG_V3_TYPE.SECOND_POSITION,
                                                                tag_type=TAG_V3_TYPE.FIRST_POSITION, get_name=True)
        second_positions_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                    agg_type=TAG_V3_TYPE.SECOND_POSITION,
                                                                    tag_type=TAG_V3_TYPE.FIRST_POSITION, get_name=False)
        res['second_positions'] = second_positions
        res['second_positions_ids'] = second_positions_ids

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.FIRST_POSITION)
    elif t.tag_type == TAG_V3_TYPE.SECOND_POSITION:  # 二级部位
        first_positions = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                               agg_type=TAG_V3_TYPE.FIRST_POSITION,
                                                               tag_type=TAG_V3_TYPE.SECOND_POSITION, get_name=True)
        first_positions_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[t.id],
                                                                   agg_type=TAG_V3_TYPE.FIRST_POSITION,
                                                                   tag_type=TAG_V3_TYPE.SECOND_POSITION, get_name=False)
        res['second_positions'] = first_positions
        res['second_positions_ids'] = first_positions_ids

        res['synonym_names'] = gets_synonym_homoionym_by_ids_names(tags_ids=[t.id], get_name=True,
                                                                   tag_type=TAG_V3_TYPE.SECOND_POSITION)
    else:
        pass

    return res


def get_itemwiki(instance):
    i = instance

    res = {
        'id': i.id,
        'item_name': i.item_name,
        'synonym': i.synonym,
        'slogan': i.slogan,
        'fit_people': i.fit_people,
        'is_online': i.is_online,
    }

    return res


def get_area_tag_info(city):
    if not city:
        return {}
    return {
        'city_tag_id': city.tag_id,
        'city_province_tag_id': city.province.tag_id,
        'city_province_country_tag_id': city.province.country.tag_id,
    }


def ignore_exception(exception_tuple, trunk, default):
    try:
        return trunk()
    except exception_tuple:
        return default


def Wiki_keyword(instance):
    i = instance
    res = {
        "id": i.id,
        'wiki_id': i.wiki_id,
        'name': i.get_wiki_id_name(),
        'is_online': i.get_wiki_id_is_online(),
        'wiki_type': i.wiki_type,
        'city_id': i.city_id,
        "visit_num": i.visit_num,
        "rank": i.rank,
        "visit_time": i.visit_time

    }
    return res
