# coding=utf-8
import json

def setup_tracer(request):
    tracer = {}
    span_name = '*'

    try:
        seqs = json.loads(request.POST['requests'])
        tracer = seqs[0]['environment'].get('trace_context', {})
        span_name = seqs[0]['method']
    except:
        pass

    if not tracer:
        return {
            'service_name': 'gaia',
            'sampled': False,
            'span_name': span_name,
        }
    return {
        'service_name': 'gaia',
        'sampled': tracer.get('sampled', False),
        'debug': tracer.get('debug', False),
        'trace_id': tracer.get('trace_id', None),
        'span_id': tracer.get('span_id', '0'),
        'span_name': span_name,
    }
