# coding=utf8
from django.db import models
from gm_upload import IMG_TYPE, ImgUrlField
from django.utils import timezone
from gm_types.gaia import YOUNG_HIT_TASK_TYPE


class BaseModel(models.Model):
    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class YoungBaseInfo(BaseModel):
    class Meta:
        verbose_name = u'少年之名活动基础信息'
        db_table = 'api_young_base_info'

    start_time = models.DateTimeField(verbose_name=u'活动开始时间')
    end_time = models.DateTimeField(verbose_name=u'活动结束时间')
    rule = models.TextField(verbose_name=u'活动规则')


class YoungTag(BaseModel):
    class Meta:
        verbose_name = u'少年之名活动标签'
        db_table = 'api_young_tag'

    young_id = models.IntegerField(verbose_name=u'少年之名活动id')
    tag_id = models.IntegerField(verbose_name=u'标签id')


class Idol(BaseModel):
    class Meta:
        verbose_name = u'少年之名学员'
        db_table = 'api_young_idol'

    name = models.CharField(verbose_name=u'名称', max_length=32)
    image = ImgUrlField(verbose_name=u'头像', img_type=IMG_TYPE.USEREXTRA, max_length=255)
    group_id = models.IntegerField(verbose_name=u'小组表ID', null=True)
    is_out = models.IntegerField(verbose_name=u'是否淘汰', default=0)

    real_votes = models.IntegerField(verbose_name=u'真实票数', default=0)
    fake_votes = models.IntegerField(verbose_name=u'虚拟票数', default=0)
    hera_votes = models.IntegerField(verbose_name=u'后台加的票数', default=0)


class IdolTag(BaseModel):
    class Meta:
        verbose_name = u'选手标签'
        db_table = 'api_young_idol_tag'

    idol_id = models.IntegerField(verbose_name=u'选手id', db_index=True)
    tag_id = models.IntegerField(verbose_name=u'标签id')


class VoteRecord(BaseModel):
    class Meta:
        verbose_name = u'投票记录'
        db_table = 'api_young_vote_record'

    user_id = models.IntegerField(verbose_name=u'用户id', db_index=True)
    idol_id = models.IntegerField(verbose_name=u'Idol表id')
    vote_date = models.DateField(verbose_name=u'投票日期', default=timezone.now, db_index=True)
    votes = models.IntegerField(verbose_name=u'票数', default=0)
    is_fake = models.BooleanField(verbose_name=u"是否是虚拟投票", default=False)


class InviteCode(BaseModel):
    class Meta:
        verbose_name = u'邀请码'
        db_table = 'api_young_invite_code'

    user_id = models.IntegerField(verbose_name=u'用户id', db_index=True)
    invite_code = models.CharField(verbose_name=u'邀请码', max_length=20, db_index=True)


class InviteRecord(BaseModel):
    class Meta:
        verbose_name = u'邀请记录'
        db_table = 'api_young_invite_record'

    user_id = models.IntegerField(verbose_name=u'邀请人')
    invited_user_id = models.IntegerField(verbose_name=u'被邀请的人', db_index=True)
    task_record_id = models.IntegerField(verbose_name=u'TaskRecord表id')


class TaskRecord(BaseModel):
    class Meta:
        verbose_name = u'完成任务记录'
        db_table = 'api_young_task_record'

    user_id = models.IntegerField(verbose_name=u'用户id', db_index=True)
    task_type = models.IntegerField(verbose_name=u'任务类型', choices=YOUNG_HIT_TASK_TYPE, default=YOUNG_HIT_TASK_TYPE.NEW_SPECIAL)
    done_date = models.DateField(verbose_name=u'完成日期', default=timezone.now, db_index=True)

    is_valid = models.BooleanField(verbose_name=u"是否有效", default=True)


class TaskConfig(BaseModel):
    class Meta:
        verbose_name = u'任务配置'
        db_table = 'api_young_task_config'

    new_special_id = models.IntegerField(verbose_name=u'新人专场id')
    group_special_id = models.IntegerField(verbose_name=u'拼团专场id')
