#!/usr/bin/env python
# -*- coding: utf-8 -*-

from talos.services import (
    TagService,
    TagV3Service,
    AgileTagService,
)
from utils.base_manager import BaseManager


class TagManager(BaseManager):
    """
    标签对外的集合
    """
    def _convert_tag_info(self, tag):
        """
        格式化老标签数据
        :param tag:
        :return:
        """
        return {
            "id": tag.id,
            "tag_id": tag.id,
            "name": tag.name,
            "tag_name": tag.name,
            "tag_type": tag.tag_type,
        }

    def _convert_agile_tag_info(self, agile_tag):
        """
        格式化新标签数据
        :param agile_tag:
        :return:
        """
        return {
            "id": agile_tag.id,
            "tag_id": agile_tag.id,
            "name": agile_tag.name,
            "tag_name": agile_tag.name,
            # "recommends_type": agile_tag.recommends_type,  # 推荐类型
            "attribute": agile_tag.attribute,  # 标签属性
        }

    def get_tags_info_by_ids(self, tag_ids):
        """
        通过老标签id获取标签信息
        :param tag_ids:
        :return: {}
        """
        tag_ids = self.filter_ids(tag_ids)
        if not tag_ids:
            return {}

        tags_info = TagService.get_tags_by_tag_ids(ids=tag_ids)

        result = {}
        for tag in tags_info:
            result[tag.id] = self._convert_tag_info(tag)

        return result

    def get_agile_tag_info_by_ids(self, tag_ids):
        """
        通过新标签id，获取新标签数据
        :param tag_ids:
        :return:
        """
        agile_tag_ids = self.filter_ids(tag_ids)
        agile_tag_info_dic = AgileTagService.get_agile_tags_by_agile_tag_ids(agile_tag_ids)

        result = {}
        for k, v in agile_tag_info_dic.items():
            result[k] = self._convert_agile_tag_info(v)

        return result

    def get_tags_v3_info_by_ids(self, tag_ids):
        """
        获取 tag 3.0 标签数据
        :param tag_ids:
        :return:
        """
        result = {}
        if not tag_ids:
            return result

        tag_v3_infos = TagV3Service.get_tags_by_tag_v3_ids(tag_v3_ids=tag_ids)
        for tag_v3_id, tag_v3_obj in tag_v3_infos.items():
            result[tag_v3_id] = TagV3Service.format_tag_v3(tag_v3_obj=tag_v3_obj)

        return result


tag_manager = TagManager()
