import logging
import time
from gm_types.gaia import TOPIC_TYPE
from gm_types.mimas import SOFT_ARTICLE_TYPE
from live.models import LiveStream, ZhiboConfig, LiveChannel
from talos.models.topic.activity import Activity
from talos.models.soft_article import SoftArticle
from talos.services.user import UserService
from talos.services.doctor import DoctorService
from talos.services.hospital import HospitalService
from data_sync.utils import tzlc
from talos.models.topic import Problem


# 直播
def get_live_stream(pks):
    # 回放的
    lives = LiveStream.objects.filter(id__in=pks)
    _channel_ids = list(filter(None, lives.values_list("channel_id", flat=True).distinct()))
    person_ids = set(LiveChannel.objects.filter(pk__in=_channel_ids).values_list("person_id", flat=True))
    user_ids = UserService._get_user_data_by_person_ids(list(person_ids))
    data = []
    for live in lives:
        item = {}
        item["id"] = live.id
        person_id = live.get_live_stream_user_id()
        user_id_id = user_ids.get(person_id, None)
        user_id = None
        if user_id_id is not None:
            user_id = user_id_id.id
        item["doctor_id"] = DoctorService.get_doctor_by_user_id_v1(user_id)
        item["user_id"] = user_id
        item["is_online"] = live.is_finish
        item["principal_type"] = 1
        try:
            start_time = tzlc(live.created_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
            end_time = tzlc(live.updated_time)
            item["end_time"] = int(time.mktime(end_time.timetuple()))
        except:
            pass
        item["zhibo_time"] = None
        item["show_order"] = 999
        item["article_type"] = None
        item["status"] = None
        item["live_status"] = live.status
        item["hera_is_online"] = None
        item["topic_isnull"] = True if live.topic else False
        item["topic_is_online"] = live.get_topic_is_online()
        item['is_test'] = live.is_test
        item['is_shouyejingxuan'] = False
        item['is_show'] = live.is_show
        item['stick_status'] = live.stick_status
        item['stick_timestamp'] = live.stick_timestamp
        us = UserService()
        hs = HospitalService()
        hospital_city_id = None
        hospital_info = us.get_doctor_hospital_id_by_user_id(user_id=user_id)
        if hospital_info.get("hospital_id"):
            hospital_id = hospital_info.get("hospital_id", None)
            hospital_city_id = hs.get_hospital_from_hospital_ids(ids=[hospital_id])
            if hospital_city_id:
                for hospital in hospital_city_id:
                    hospital_city_id = hospital.city_tag_id

        elif hospital_info.get("doctor_id"):
            doctor_id = hospital_info.get("doctor_id", None)
            hospital = hs.get_hospital_from_doctor_id(id=doctor_id)
            if hospital:
                hospital_id = hospital.id
                hospital_city_id = hs.get_hospital_from_hospital_ids(ids=[hospital_id])
                if hospital_city_id:
                    for hospital in hospital_city_id:
                        hospital_city_id = hospital.city_tag_id

        item['allow_city'] = live.allow_city(hospital_city_id, live.id)

        data.append(item)
    logging.info("get data:%s" % data)

    return data


# 预告
def get_live_notice(pks):
    notices = ZhiboConfig.objects.filter(id__in=pks)

    data = []
    for notice in notices:
        item = {}
        item["id"] = notice.id
        item["doctor_id"] = DoctorService.get_doctor_by_user_id_v1(notice.anchor_user_id)
        item["user_id"] = notice.anchor_user_id
        item["is_online"] = notice.is_online
        item["principal_type"] = 3
        try:
            start_time = tzlc(notice.start_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
            end_time = tzlc(notice.end_time)
            item["end_time"] = int(time.mktime(end_time.timetuple()))
            zhibo_time = tzlc(notice.zhibo_time)
            item["zhibo_time"] = int(time.mktime(zhibo_time.timetuple()))
        except:
            pass
        item['is_shouyejingxuan'] = True if notice.is_shouyejingxuan else False
        item["show_order"] = 999
        item["article_type"] = None
        item["status"] = None
        item["live_status"] = None
        item["hera_is_online"] = None
        item["topic_isnull"] = None
        item["topic_is_online"] = None
        item['is_show'] = 1
        data.append(item)
    logging.info("get data:%s" % data)

    return data


# 免费招募
def get_activity(pks):
    activities = Activity.objects.filter(id__in=pks)

    data = []
    for activity in activities:
        item = {}
        item["id"] = activity.id
        item["doctor_id"] = activity.doctor_id
        item["user_id"] = ''
        item["is_online"] = activity.is_online
        item["principal_type"] = 2
        try:
            start_time = tzlc(activity.start_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
            end_time = tzlc(activity.end_time)
            item["end_time"] = int(time.mktime(end_time.timetuple()))

        except:
            pass
        item["zhibo_time"] = None
        item["show_order"] = 999
        item["article_type"] = None
        item["status"] = None
        item["live_status"] = None
        item["hera_is_online"] = None
        item["topic_isnull"] = None
        item["topic_is_online"] = None
        item['is_shouyejingxuan'] = False
        item['is_show'] = 1
        data.append(item)
    logging.info("get data:%s" % data)

    return data


# 视频贴
def get_video_tractate(pks):
    softarticles = SoftArticle.objects.filter(id__in=pks, article_type=SOFT_ARTICLE_TYPE.VIDEO)

    data = []
    for softarticle in softarticles:
        item = {}
        item["id"] = softarticle.id
        item["doctor_id"] = softarticle.doctor_id
        item["user_id"] = ""
        item["is_online"] = softarticle.is_online
        item["principal_type"] = 4
        try:
            start_time = tzlc(softarticle.create_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
        except:
            pass
        item["end_time"] = None
        item["zhibo_time"] = None
        item["show_order"] = softarticle.show_order
        item["article_type"] = softarticle.article_type
        item["status"] = softarticle.status
        item["live_status"] = None
        item["hera_is_online"] = softarticle.hera_is_online
        item["topic_isnull"] = None
        item["topic_is_online"] = None
        item['is_shouyejingxuan'] = False
        item['is_show'] = 1
        data.append(item)
    logging.info("get data:%s" % data)

    return data


# 文本帖
def get_word_tractate(pks):
    softarticles = SoftArticle.objects.filter(id__in=pks, article_type=SOFT_ARTICLE_TYPE.ORDINARY)

    data = []
    for softarticle in softarticles:
        item = {}
        item["id"] = softarticle.id
        item["doctor_id"] = softarticle.doctor_id
        item["user_id"] = ""
        item["is_online"] = softarticle.is_online
        item["principal_type"] = 5
        try:
            start_time = tzlc(softarticle.create_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
        except:
            pass
        item["end_time"] = None
        item["zhibo_time"] = None
        item["show_order"] = softarticle.show_order
        item["article_type"] = softarticle.article_type
        item["status"] = softarticle.status
        item["live_status"] = None
        item["hera_is_online"] = softarticle.hera_is_online
        item["topic_isnull"] = None
        item["topic_is_online"] = None
        item['is_shouyejingxuan'] = False
        item['is_show'] = 1
        data.append(item)
    logging.info("get data:%s" % data)

    return data


# 专栏
def get_article(pks):
    articles = Problem.objects.filter(
        id__in=pks,
        topic_type__in=[TOPIC_TYPE.COLUMN_ARTICLE, TOPIC_TYPE.USER_ARTICLE]
    )
    data = []
    for article in articles:
        item = {}
        item["id"] = article.id
        item["user_id"] = article.user_id
        item["doctor_id"] = UserService.get_doctor_id_from_user_id(article.user_id)
        logging.info("get doctor_id:%s" % item["doctor_id"])
        item["is_online"] = article.is_online
        item["principal_type"] = 6
        try:
            start_time = tzlc(article.created_time)
            item["start_time"] = int(time.mktime(start_time.timetuple()))
        except:
            pass
        item["end_time"] = None
        item["zhibo_time"] = None
        item["show_order"] = 999
        item["article_type"] = None
        item["status"] = None
        item["live_status"] = None
        item["hera_is_online"] = None
        item["topic_isnull"] = None
        item["topic_is_online"] = None
        item['is_shouyejingxuan'] = False
        item['is_show'] = 1
        data.append(item)
    logging.info("get data:%s" % data)

    return data
