# coding=utf-8
import os

import xlrd

base_path = os.path.join(os.path.dirname(__file__), "files")


def get_tag_old_new_relations():
    relation_dict = {}
    try:
        relation_file = os.path.join(base_path, "新老标签映射-v09-1216.xlsx")
        relation_data = xlrd.open_workbook(relation_file)
        relation_sheet = relation_data.sheet_by_name("新老标签映射")

        for row in range(2, relation_sheet.nrows):
            key = relation_sheet.cell_value(row, 1)
            value = relation_sheet.cell_value(row, 3)
            if key not in relation_dict:
                relation_dict[key] = value
        return relation_dict
    except Exception as e:
        print(str(e))
        return relation_dict


def remove_null(l):
    return list(filter(None, l))


def remove_duplicated(l):
    new_list = list(set(l))
    new_list.sort(key=l.index)
    return new_list


def get_new_tag_data():
    res = {}
    try:
        tag_file = os.path.join(base_path, "新标签1218.xlsx")
        tag_data = xlrd.open_workbook(tag_file)
        tag_sheet = tag_data.sheet_by_name("标签")

        for row in range(1, tag_sheet.nrows):
            key = tag_sheet.cell_value(row, 0)
            first_demands = []
            second_demands = []
            first_solutions = []
            second_solutions = []
            positions = []

            second_demands.append(tag_sheet.cell_value(row, 2))
            second_demands.append(tag_sheet.cell_value(row, 3))

            first_demands.append(tag_sheet.cell_value(row, 4))

            second_solutions.append(tag_sheet.cell_value(row, 5))
            second_solutions.append(tag_sheet.cell_value(row, 6))
            second_solutions.append(tag_sheet.cell_value(row, 7))

            first_solutions.append(tag_sheet.cell_value(row, 8))

            for i in range(9, 22):
                positions.append(tag_sheet.cell_value(row, i))

            res[key] = [
                remove_null(first_demands),
                remove_null(second_demands),
                remove_null(first_solutions),
                remove_null(second_solutions),
                remove_null(positions)
            ]

        return res
    except Exception as e:
        print(str(e))
        return res


def get_new_tags_from_old_tags(old_tags, old_new_dict):
    try:
        new_tags = []
        for i in old_tags:
            if old_new_dict.get(i):
                new_tags.append(old_new_dict.get(i))
        return remove_duplicated(new_tags)
    except Exception as e:
        print(str(e))
        return []


def get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, index):
    try:
        new_tags = []
        for i in old_tags:
            if old_new_dict.get(i):
                new_tags.append(old_new_dict.get(i))

        res = []
        for i in new_tags:
            if new_tag_data.get(i):
                res.extend(new_tag_data[i][index])
        return remove_duplicated(res)
    except Exception as e:
        print(str(e))
        return []


def get_first_demands_from_old_tags(old_tags, old_new_dict, new_tag_data):
    return get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, 0)


def get_second_demands_from_old_tags(old_tags, old_new_dict, new_tag_data):
    return get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, 1)


def get_first_solutions_from_old_tags(old_tags, old_new_dict, new_tag_data):
    return get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, 2)


def get_second_solutions_from_old_tags(old_tags, old_new_dict, new_tag_data):
    return get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, 3)


def get_positions_from_old_tags(old_tags, old_new_dict, new_tag_data):
    return get_tag_specific_data_from_old_tags(old_tags, old_new_dict, new_tag_data, 4)
