import pili
from django.conf import settings
from live.models import LiveStream
from django.utils import timezone
from live.managers import create_stream_replay_danmu
from talos.rpc import logging_exception
from django.core.management import BaseCommand

from talos.libs.datetime_utils import get_timestamp_or_none

ts_now_as_score = lambda: get_timestamp_or_none(timezone.now())


class Command(BaseCommand):
    def handle(self, *args, **options):
        mac = pili.Mac(settings.QINIU_ACCESS_KEY, settings.QINIU_SECRET_KEY)
        client = pili.Client(mac)
        hub = client.hub(settings.QINIU_HUB_NAME)
        try:
            stream = LiveStream.objects.get(pk=1634)
            s = hub.get(stream.stream_key)
            url = s.save_as(1559549807 + 3960, 0)
            stream.save_replay_url = url['fname']
            stream.save(update_fields=['save_replay_url'])
            # create_stream_replay_danmu(stream.id)
        except:
            logging_exception()
            # /recordings/z1.igengmei-live.live1559549807_31058544/0_1559585545.m3u8   原来的  save_replay_url 字段值
