#!/usr/bin/env python
# -*- coding: utf-8 -*-

import openpyxl
import os
import random

from django.conf import settings
from django.core.management import BaseCommand
from qa.models import TouTiaoTag, ToutiaoRelation

'''
趣头条-首期数据同步
'''

def read_from_file(path):
    data_dict = dict()
    file_name = path + 'tags_relation.xlsx'
    wb = openpyxl.load_workbook(file_name)
    data_sheet = wb['Mysheet']

    for row in data_sheet.rows:
        if row[2].value:
            data_dict[row[0].value] = list(set(row[2].value.split(',')))
        else:
            data_dict[row[0].value] = ''

    return data_dict


def insert_toutiaotag_data(data_dict):
    insert_list, insert_relation_data_list, insert_relation_data_dict = [], [], {}
    for name in data_dict:
        has_vaule = bool(data_dict.get(name))
        create_kwargs = {
            'toutiao': name,
            'is_related': bool(has_vaule),
        }
        if has_vaule:
            insert_relation_data_dict[name] = data_dict[name]
        insert_list.append(TouTiaoTag(**create_kwargs))

    print('---------insert list length------------')
    print(len(insert_list))
    print('---------insert list length-------------')
    TouTiaoTag.objects.bulk_create(insert_list)

    return insert_relation_data_dict

def get_toutiaotag_ids():
    ret_dict = dict()
    ids_toutiao = TouTiaoTag.objects.filter(is_related=True).values("id", "toutiao")
    for _data in ids_toutiao:
        ret_dict[_data['toutiao']] = _data['id']
    return ret_dict


def insert_toutiaotag_relation_data(ret_dict, insert_relation_data_dict):

    insert_relation_data_list = []
    for toutiaotag in insert_relation_data_dict:
        for tag_id in insert_relation_data_dict[toutiaotag]:
            create_kwargs = {
                'toutiaotag_id': ret_dict[toutiaotag],
                'tag': str(random.randint(1,258)) if settings.DEBUG else tag_id, # 如果是测试环境,随机生成测试库标签ID
            }
            insert_relation_data_list.append(ToutiaoRelation(**create_kwargs))
    ToutiaoRelation.objects.bulk_create(insert_relation_data_list)


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        print("start")
        parent_path = os.path.abspath(os.path.join(os.path.dirname(__file__), os.path.pardir))
        path = parent_path+'/files/'  # 文件上传地址确定

        data_dict = read_from_file(path)
        print('get data from file : done')

        insert_relation_data_dict = insert_toutiaotag_data(data_dict)
        print('insert data to Toutiaotag : done')
        ret_dict = get_toutiaotag_ids()
        insert_toutiaotag_relation_data(ret_dict, insert_relation_data_dict)
        print('insert data to ToutiaoTagRelation : done')
        print("end")