import redis
import time
from django.conf import settings
from django.core.management import BaseCommand


class Command(BaseCommand):

    def handle(self, *args, **options):
        """
        redis migrate.
        :param args:
        :param options:
        :return:
        """
        redis_cofig = settings.GM_SERIALIZER.get('redis')

        pool = redis.ConnectionPool(host=redis_cofig.get('host'), port=redis_cofig.get('port'), db=redis_cofig.get('db'),
                                    password=redis_cofig.get('password'))
        r = redis.Redis(connection_pool=pool)
        count = 0
        for key in r.scan_iter(match='user:*', count=200):
            count = count + 1
            r.delete(key)
            time.sleep(0.1)
        print("user_cache del count ", count)
        print("Done")

