
import functools

from django.conf import settings


def listing(arg_limit='count'):
    def wrapper(f):
        @functools.wraps(f)
        def inner(*args, **kwargs):
            limit = kwargs.get(arg_limit, 0)
            if limit:
                kwargs[arg_limit] = settings.COUNT_LIMIT if limit > settings.COUNT_LIMIT else limit
            return f(*args, **kwargs)
        return inner
    return wrapper
