# coding=utf-8
from __future__ import unicode_literals, absolute_import

from talos.models.topic import Problem
from rpc.decorators import bind_context

from social.models import UserFollow
from social.consts import SUOZHANG_UID
from social.tasks import create_feed
from social.types import IN_FEED_REASON



@bind_context('social/user/follow')
def user_relation(ctx, user_id, follow_id):
    query = UserFollow.objects.filter(user_id=user_id, follow_id=follow_id, bond=True)
    followed = query.exists()
    return {'followed': followed}


@bind_context('social/suozhang/push_topic_in_mailbox')
def push_topic_in_mailbox(ctx, id):
    try:
        p = Problem.objects.get(id=id)
    except:
        return

    if p.user.id != SUOZHANG_UID or not p.is_online:
        return

    create_feed.delay(
        uid=SUOZHANG_UID,
        follow_uid=SUOZHANG_UID,
        topic_id=p.id,
        feed_reason=IN_FEED_REASON.MY_TOPIC
    )
