# coding:utf-8
"""标签3.0"""

from django.db import models
from django.utils import timezone

from gm_types.gaia import TAG_TYPE_ATTR, TAG_V3_TYPE, TAG_TYPE
from gm_upload import ImgUrlField, IMG_TYPE


class BaseModel(models.Model):

    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class TagV3(BaseModel):
    class Meta:
        verbose_name = u'标签3.0'
        db_table = 'api_tag_3_0'

    name = models.CharField(verbose_name=u'标签名字', max_length=128, null=False, unique=True, default='')
    homoionym = models.CharField(verbose_name=u'近义词', max_length=1024, db_index=True)
    is_display = models.BooleanField(verbose_name=u"是否显示", default=True)
    tag_type = models.IntegerField(verbose_name=u'标签分类', default=TAG_V3_TYPE.NORMAL)


class TagV3MapAttrTag(BaseModel):

    class Meta:
        verbose_name = u'标签和属性标签映射关系'
        db_table = 'api_tag_attr_tag'

    tag_id = models.IntegerField(verbose_name=u'标签ID', null=False)
    tag_attr_id = models.IntegerField(verbose_name=u"属性标签")


class TagExtra(BaseModel):

    class Meta:
        verbose_name = u'标签统计信息'
        db_table = 'api_tag_extra'

    aggregate_type = models.CharField(verbose_name=u"集合类型", max_length=3, choices=TAG_TYPE_ATTR)
    count = models.IntegerField(verbose_name=u'数量', null=False)
    tag_id = models.IntegerField(verbose_name=u'标签ID', null=False)


class TagSynonym(BaseModel):

    class Meta:
        verbose_name = u'标签集合'
        db_table = 'api_tag_aggregate'

    name = models.CharField(verbose_name=u'同义词名称', max_length=128, db_index=True)
    tag_id = models.IntegerField(verbose_name=u'标签ID', null=False)


class TagMapOldTag(BaseModel):

    class Meta:
        verbose_name = u'新标签与老标签映射关系(可多选)'
        db_table = 'api_tag_map_oldtag'

    tag_id = models.IntegerField(verbose_name=u'标签3.0', db_index=True)
    old_tag_id = models.IntegerField(verbose_name=u'老标签', db_index=True)

    @classmethod
    def add_relation_by_id(cls, old_tag_id, tag_id):
        rel, _ = cls.objects.update_or_create(old_tag_id=old_tag_id, tag_id=tag_id, defaults={'is_online': True})
        return rel


class AttrTag(BaseModel):

    class Meta:
        verbose_name = u'属性标签'
        db_table = 'api_tag_attr'

    name = models.CharField(verbose_name=u'名称', max_length=128, null=False, db_index=True, default='')
    homoionym = models.CharField(verbose_name=u'近义词', max_length=1024, db_index=True)
    aggregate_type = models.CharField(verbose_name=u"集合类型", max_length=3, choices=TAG_TYPE_ATTR, default=TAG_TYPE_ATTR.SYMPTOM)


class AttrTagSynonym(BaseModel):

    class Meta:
        verbose_name = u'属性标签同义词'
        db_table = 'api_tag_attr_synonym'

    tag_attr_id = models.IntegerField(verbose_name=u'标签ID', null=False, db_index=True)
    name = models.CharField(verbose_name=u'同义词名称', max_length=128, db_index=True)


class TagCategory(BaseModel):

    class Meta:
        verbose_name = u'标签3.0大类'
        db_table = 'api_tag_category'

    name = models.CharField(verbose_name=u'大类名称', max_length=128, db_index=True)


class TagCategoryMapTag(BaseModel):

    class Meta:
        verbose_name = u'标签3.0大类'
        db_table = 'api_tag_category_tag'

    tag_id = models.IntegerField(verbose_name=u'新标签ID', db_index=True)
    tag_category_id = models.IntegerField(verbose_name=u"标签大类id", db_index=True)

class StrategyQuestionTagV3(models.Model):
    class Meta:
        verbose_name = u'标签3.0'
        db_table = 'strategy_question_tagv3_info'
    content_id = models.IntegerField(verbose_name=u'内容id')
    second_demands = models.CharField(verbose_name=u'二级诉求', max_length=128, default='')
    second_solutions = models.CharField(verbose_name=u'二级方式', max_length=128, default='')
    second_positions = models.CharField(verbose_name=u'二级部位', max_length=128, default='')
    first_demands = models.CharField(verbose_name=u'一级诉求', max_length=128, default='')
    first_solutions = models.CharField(verbose_name=u'一级方式', max_length=128, default='')
    first_positions = models.CharField(verbose_name=u'一级部位', max_length=128, default='')
    project_tags = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    project_tags_ids = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    first_classify_ids = models.CharField(verbose_name=u'一级分类id', max_length=128, default='')
    second_classify_ids = models.CharField(verbose_name=u'二级分类id', max_length=128, default='')
    first_classify_names = models.CharField(verbose_name=u'一级分类名称', max_length=128, default='')
    second_classify_names = models.CharField(verbose_name=u'二级分类名称', max_length=128, default='')
    stat_date = models.CharField(verbose_name=u'统计日期', max_length=128, null=False)


class StrategyArticleTagV3(models.Model):
    class Meta:
        verbose_name = u'标签3.0'
        db_table = 'strategy_article_tagv3_info'
    content_id = models.IntegerField(verbose_name=u'内容id')
    second_demands = models.CharField(verbose_name=u'二级诉求', max_length=128, default='')
    second_solutions = models.CharField(verbose_name=u'二级方式', max_length=128, default='')
    second_positions = models.CharField(verbose_name=u'二级部位', max_length=128, default='')
    first_demands = models.CharField(verbose_name=u'一级诉求', max_length=128, default='')
    first_solutions = models.CharField(verbose_name=u'一级方式', max_length=128, default='')
    first_positions = models.CharField(verbose_name=u'一级部位', max_length=128, default='')
    project_tags = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    project_tags_ids = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    first_classify_ids = models.CharField(verbose_name=u'一级分类id', max_length=128, default='')
    second_classify_ids = models.CharField(verbose_name=u'二级分类id', max_length=128, default='')
    first_classify_names = models.CharField(verbose_name=u'一级分类名称', max_length=128, default='')
    second_classify_names = models.CharField(verbose_name=u'二级分类名称', max_length=128, default='')
    stat_date = models.CharField(verbose_name=u'统计日期', max_length=128, null=False)


class StrategyAnswerTagV3(models.Model):
    class Meta:
        verbose_name = u'标签3.0'
        db_table = 'strategy_answer_tagv3_info'
    content_id = models.IntegerField(verbose_name=u'内容id')
    question_id = models.IntegerField(verbose_name=u'问题id')
    second_demands = models.CharField(verbose_name=u'二级诉求', max_length=128, default='')
    second_solutions = models.CharField(verbose_name=u'二级方式', max_length=128, default='')
    second_positions = models.CharField(verbose_name=u'二级部位', max_length=128, default='')
    first_demands = models.CharField(verbose_name=u'一级诉求', max_length=128, default='')
    first_solutions = models.CharField(verbose_name=u'一级方式', max_length=128, default='')
    first_positions = models.CharField(verbose_name=u'一级部位', max_length=128, default='')
    project_tags = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    project_tags_ids = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    first_classify_ids = models.CharField(verbose_name=u'一级分类id', max_length=128, default='')
    second_classify_ids = models.CharField(verbose_name=u'二级分类id', max_length=128, default='')
    first_classify_names = models.CharField(verbose_name=u'一级分类名称', max_length=128, default='')
    second_classify_names = models.CharField(verbose_name=u'二级分类名称', max_length=128, default='')
    stat_date = models.CharField(verbose_name=u'统计日期', max_length=128, null=False)

class StrategyTractateTagV3(models.Model):
    class Meta:
        verbose_name = u'标签3.0'
        db_table = 'strategy_tractate_tagv3_info'
    content_id = models.IntegerField(verbose_name=u'内容id')
    second_demands = models.CharField(verbose_name=u'二级诉求', max_length=128, default='')
    second_solutions = models.CharField(verbose_name=u'二级方式', max_length=128, default='')
    second_positions = models.CharField(verbose_name=u'二级部位', max_length=128, default='')
    first_demands = models.CharField(verbose_name=u'一级诉求', max_length=128, default='')
    first_solutions = models.CharField(verbose_name=u'一级方式', max_length=128, default='')
    first_positions = models.CharField(verbose_name=u'一级部位', max_length=128, default='')
    project_tags = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    project_tags_ids = models.CharField(verbose_name=u'项目标签', max_length=128, default='')
    first_classify_ids = models.CharField(verbose_name=u'一级分类id', max_length=128, default='')
    second_classify_ids = models.CharField(verbose_name=u'二级分类id', max_length=128, default='')
    first_classify_names = models.CharField(verbose_name=u'一级分类名称', max_length=128, default='')
    second_classify_names = models.CharField(verbose_name=u'二级分类名称', max_length=128, default='')
    stat_date = models.CharField(verbose_name=u'统计日期', max_length=128, null=False)


class Tag(models.Model):
    """ 标签1.0 copy"""

    class Meta:
        verbose_name = "标签"
        verbose_name_plural = "标签"
        app_label = 'api'

    name = models.CharField(
        verbose_name='名称',
        max_length=64,
        null=False,
        blank=False,
        db_index=True,
        unique=True,
    )
    tag_type = models.CharField(
        verbose_name='标签类型',
        max_length=4,
        null=False,
        blank=False,
        choices=TAG_TYPE,
    )
    is_online = models.BooleanField(
        null=False, default=True, verbose_name='是否上线')

    recommend_type = models.CharField(max_length=1, verbose_name='推荐类型')
    banner_url = ImgUrlField(img_type=IMG_TYPE.TAG,
                             max_length=120, verbose_name='banner', blank=True, default='')
    show_diary = models.BooleanField(verbose_name='显示日记本', default=False)
    show_wiki = models.BooleanField(verbose_name='显示介绍/百科', default=False)
    show_service = models.BooleanField(verbose_name='显示美购', default=False)
    show_similar = models.BooleanField(verbose_name='显示同类话题组', default=False)
    ordering = models.IntegerField(
        default=99999, verbose_name="展示顺序", help_text="小的排在前，大的排在后")  # TODO: rename to rank?
    description = models.TextField(
        max_length=1024, verbose_name='', blank=True, default='')
    icon_url = ImgUrlField(
        img_type=IMG_TYPE.TAG,
        max_length=120, verbose_name='icon url', blank=True, default='')
    free_to_add = models.BooleanField(verbose_name='用户可自由添加', default=True)
    recommended_to_follow = models.BooleanField(
        verbose_name='是否推荐用户关注', default=False)
    managers = models.ManyToManyField(
        'Person', related_name="tags")  # api_tag_managers diary_tags
    re_purchase_days = models.IntegerField(verbose_name=u'复购天数', default=0)

    resembles = models.ManyToManyField('self', verbose_name=u'近义关系')
