# coding=utf-8

import math
import time
from multiprocessing import Pool, Manager

from django.core.management.base import BaseCommand
from django.db.models import Q, Max
from django import db
from talos.models.diary import Diary


def update_share_count(queue, limit):
    """新加日记分享次数数据  新加规则 (点赞数+收藏数) /2"""
    start_id = queue.get()
    print(start_id)
    diarys = Diary.objects.filter(Q(pk__gt=start_id))[: limit]
    max_id = diarys.aggregate(max_id=Max('id'))
    queue.put(max_id["max_id"])
    if not diarys:
        return

    for diary in diarys:

        vote_num = diary.vote_num
        fav_count = diary.favor_diary_diary.all().count()
        diary.share_num = int(math.ceil((vote_num + fav_count) / 2))
        diary.save(update_fields=["share_num"])


class Command(BaseCommand):
    def handle(self, *args, **options):
        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        queue = Manager().Queue(maxsize=4)
        queue.put(0)  # 触发程序开始

        args_list = []
        per_num = 200
        count = Diary.objects.filter(is_online=True).count()
        cnt = int(math.ceil(count / per_num))
        for _ in range(cnt):
            args_list.append((queue, per_num))

        db.connections.close_all()
        pool = Pool(processes=4)
        pool.starmap(update_share_count, args_list)
        pool.close()
        pool.join()

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')

