# coding:utf-8
"""导出日记本大赛相关日记"""

import os
import os.path
import datetime
import time

from django.conf import settings
from django.core.management.base import BaseCommand
from utils.execel import ExcelReader, ExcelWriter
from talos.models.topic import Problem,ProblemTag
from gm_types.gaia import TOPIC_TYPE
from talos.services.user import UserService


def export_diary_for_match():
    result_path = os.path.dirname(__file__)
    start_date = datetime.date(2018, 10, 22)
    end_date = datetime.date(2018, 11, 5)
    topics_ids = ProblemTag.objects.using(settings.SLAVE_DB_NAME).filter(
        tag_id=settings.DIARY_MATCH_TAG_ID).values_list(
        "problem",
        flat=True).distinct()
    topics = Problem.objects.using(settings.SLAVE_DB_NAME).filter(created_time__gte=start_date,
                                                                  created_time__lt=end_date, diary__isnull=False,
                                                                  topic_type=TOPIC_TYPE.SHARE,
                                                                  is_online=True, id__in=topics_ids).order_by(
        "diary_id").iterator()
    result_excel = os.path.join(result_path, "日记本大赛.xlsx")
    excel = ExcelWriter(result_excel)
    excel.write_header(["日记本ID", "帖子ID", "日记帖评论人数", "日记帖评论数", "用户名", "用户 ID", "绑定标签", "日记帖发帖时间"])
    row = 1
    for topic in topics:
        dairy_id = topic.diary_id if topic.diary_id else ""
        id = topic.id
        comment_user_num = topic.topicreply_set.filter(is_online=True).values_list("user_id",
                                                                                   flat=True).distinct().count()
        comment_num = topic.reply_num if topic.reply_num else 0
        user_name = ""
        user_id = ""
        if topic.user_id:
            me = UserService.get_user_by_user_id(topic.user_id)
            user_name = me.nickname if me.nickname else ""
            user_id = topic.user_id
        tags = ""
        if topic.tags:
            tags = [tag.name for tag in topic.tags]
            tags = ','.join(tags)
        created_time = topic.created_time.strftime("%Y-%m-%d %H:%M:%S")
        row = row+1
        excel.write_row(row, [dairy_id, id, comment_user_num, comment_num, user_name, user_id, tags, created_time])
    excel.save()


class Command(BaseCommand):
    def handle(self, *args, **options):
        """导出日记本信息"""

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)
        export_diary_for_match()
        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
