# coding:utf-8
"""导出优质日记本（评分3.5分及以上)"""

import json

from talos.models.diary.diary import Diary
from talos.rpc import get_current_rpc_invoker
from django.core.management import BaseCommand

from utils.execel import ExcelWriter
from talos.services.goods import GoodsService
from talos.services.order import OrderService

max_diary_info = Diary.objects.filter(content_level=[3.5, 4, 5], is_online=True).order_by("id").last()


excel = ExcelWriter("diary_cpc.xlsx")
excel.write_header(['日记本ID', '日记本名称', '日记本星级', '是否开通CPC内容', '机构ID', '机构名称', '商务', '商务组'])


def get_diary_data(diaries):
    row = 2
    for diary in diaries:
        try:
            print("当前处理的日记本ID", diary.id)
            rpc = get_current_rpc_invoker()
            cpc_dic = rpc["artemis/cpc_community/diary/is_cpc"](diary_id=diary.id).unwrap()
            cpc_result = "是" if cpc_dic.get("is_cpc") else "否"
            if not diary.service_id and not diary.order_id:
                excel.write_row(row_num=row, values=[
                    diary.id,
                    diary.title,
                    diary.content_level,
                    cpc_result,
                    "",
                    "",
                    "",
                    "",
                ])
                row += 1
                continue

            service_id = diary.service_id
            if not diary.service_id and diary.order_id:
                order_info = OrderService.get_order_from_order_id(id=diary.order_id)
                service_info = json.loads(order_info.service_snapshot)
                service_id = service_info.get("id") or diary.service_id

            service = GoodsService.get_service_by_service_id(service_id)
            if not service or not service.doctor:
                excel.write_row(row_num=row, values=[
                    diary.id,
                    diary.title,
                    diary.content_level,
                    cpc_result,
                    "",
                    "",
                    "",
                    "",
                ])
                row += 1
                continue

            doctor_id = service.doctor.id
            doctor_info = rpc['doctor/get_info/by_ids'](doctor_ids=[doctor_id, ]).unwrap()[0]

            excel.write_row(row_num=row, values=[
                diary.id,
                diary.title,
                diary.content_level,
                cpc_result,
                doctor_info.get('hospital_id', ''),
                doctor_info.get('hospital_name', ''),
                doctor_info.get('business', ''),
                doctor_info.get('business_group', ''),
            ])
            row += 1
            continue
        except Exception as e:
            print(e)
            row += 1
            continue


class Command(BaseCommand):

    def handle(self, *args, **options):
        diaries = Diary.objects.filter(content_level__in=[3.5, 4, 5], is_online=True)
        get_diary_data(diaries=diaries)

        excel.save()
        print('Excel已完成')

