"""初始化点赞数据。"""

from django.core.management import BaseCommand
from django.conf import settings

from talos.models.topic import TopicVote, TopicReplyVote
from talos.models.diary import DiaryVote
from talos.models.tractate import TractateVote, TractateReplyVote
from talos.services.tractate import TractateService, TractateReplyService
from talos.tools.vote_tool import VoteTool
from qa.models import AnswerVote
from talos.cache.base import vote_cache


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        PAGE_SIZE = 500

        print(0)
        start_id = 0
        qs = DiaryVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs:
            for dv in qs:
                try:
                    user_id = dv.diary.user_id
                except:
                    continue
                if dv.user_id == user_id:
                    continue

                tool = VoteTool(vote_cache, user_id, new_version=True)
                tool.receive_diary_vote(dv.id, dv.vote_time)

            qs = DiaryVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
            start_id += PAGE_SIZE


        print(1)
        start_id = 0
        qs = TopicVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs:
            for tv in qs:
                try:
                    user_id = tv.topic.user_id
                except:
                    continue
                if tv.user_id == user_id:
                    continue

                tool = VoteTool(vote_cache, user_id, new_version=True)
                tool.receive_topic_vote(tv.id, tv.vote_time)

            qs = TopicVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
            start_id += PAGE_SIZE


        print(2)
        start_id = 0
        qs = TopicReplyVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs:
            for trv in qs:

                try:
                    user_id = trv.topic_reply.user_id
                except:
                    continue
                if trv.user_id == user_id:
                    continue

                tool = VoteTool(vote_cache, user_id, new_version=True)
                tool.receive_topic_reply_vote(trv.id, trv.vote_time)

            qs = TopicReplyVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
            start_id += PAGE_SIZE


        print(3)
        start_id = 0
        qs = TractateVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs:
            for trac_vote in qs:
                tractate = TractateService.get_by_id(trac_vote.tractate_id)
                if tractate:
                    if trac_vote.user_id == tractate.user_id:
                        continue
                    tool = VoteTool(vote_cache, tractate.user_id, new_version=True)
                    tool.receive_tractate_vote(trac_vote.id, trac_vote.update_time)

            qs = TractateVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
            start_id += PAGE_SIZE


        print(4)
        start_id = 0
        qs = TractateReplyVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
        while qs:
            for trac_re_vote in qs:
                trac_reply = TractateReplyService.get_by_id(trac_re_vote.reply_id)
                if trac_reply:
                    if trac_re_vote.user_id == trac_reply.user_id:
                        continue

                    tool = VoteTool(vote_cache, trac_reply.user_id, new_version=True)
                    tool.receive_tractate_reply_vote(trac_re_vote.id, trac_re_vote.update_time)

            qs = TractateReplyVote.objects.using(settings.SLAVE_DB_NAME).filter(pk__gte=start_id, pk__lte=start_id + PAGE_SIZE)
            start_id += PAGE_SIZE
