#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import openpyxl
from django.core.management.base import BaseCommand

from gm_types.gaia import DIARY_CONTENT_LEVEL

from talos.models.diary import Diary


def read_from_file(path):
    re_data = set()
    sheet_name = 'Sheet1'
    file_name = path + 'change_diary_content_level_ids.xlsx'

    wb = openpyxl.load_workbook(file_name)
    data_sheet = wb[sheet_name]
    for i, row in enumerate(data_sheet.rows):
        if i and row[0].value:
            re_data.add(int(row[0].value))

    return list(re_data)


class Command(BaseCommand):

    def handle(self, *args, **options):

        print("BEGIN")

        parent_path = os.path.dirname(os.path.dirname(__file__))

        path = parent_path + '/files/'  # 文件上传地址确定
        diary_ids = read_from_file(path)

        Diary.objects.filter(pk__in=diary_ids, is_online=True).update(content_level=DIARY_CONTENT_LEVEL.BETTER)

        print("END")
