#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.utils import timezone

from .diary import Diary


class BDDiary(models.Model):

    class Meta:
        app_label = 'talos'
        db_table = 'bd_diary'
        verbose_name = u'百度熊掌号日记本'

    diary = models.OneToOneField(Diary, related_name="bd_diary")
    is_submit = models.BooleanField(verbose_name='是否已提交', default=False)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    submit_time = models.DateTimeField(verbose_name=u'提交时间', auto_now=True)