# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

import datetime
from django.conf import settings
from django.db import models
from functools import reduce
from gm_types.gaia import DIARY_OPERATE

from talos.models.diary.diary import Diary


class DiaryRank(models.Model):
    """
    日记本排序 for 首页排序推荐
    """

    class Meta:
        verbose_name = u'日记本首页排序分值'
        db_table = 'api_diaryrank'
        app_label = 'talos'

    diary = models.OneToOneField(Diary, related_name='diary_rank')
    heat_score = models.FloatField(verbose_name=u'热度分', blank=True, default=0)
    additional_score = models.IntegerField(verbose_name=u'附加分数', default=0)

    @classmethod
    def group_nested_list(cls, l1, l2):
        assert len(l1) == len(l2)
        a = [l1[i] + l2[i] for i in range(len(l1))]
        return a

    def get_period_op_history(self, start_time, days=1):
        raw_history = [self.get_one_day_op_history(start_time + datetime.timedelta(days=i)) for i in range(days)]
        grouped_history = reduce(self.group_nested_list, raw_history, [[], [], [], [], []])
        print (u"1、创建日记贴 2、修改日记本 3、自己回复 4、他人回复 5、他人点赞")
        return grouped_history

    def get_one_day_op_history(self, start_time):
        end_time = start_time + datetime.timedelta(days=1)
        u = self.diary.user
        do = self.diary.diary_operations
        tr = self.diary.topicreply_set.all()
        dv = self.diary.diary_votes
        _t = self.diary.topics
        tv = Diary.objects.none().all()
        for t in _t.all():
            tr = tr | t.topicreply_set.all()
            tv = tv | t.votes.all()

        restrict = settings.DIARY_HEAT_RANK
        create_topic = do.filter(operate_time__range=(start_time, end_time), operation=DIARY_OPERATE.ADD_TOPIC).values(
            'topic',
            'diary_id',
            'operate_time',
            'operation',
        )[:restrict['restrict_create_topic']]
        modify_diary = do.filter(operate_time__range=(start_time, end_time), operation__in=[DIARY_OPERATE.UPDATE_INFO,
                                 DIARY_OPERATE.UPDATE_TOPIC]).values(
            'topic',
            'diary_id',
            'operate_time',
            'operation',
        )[:restrict['restrict_modify_diary']]
        self_reply = tr.filter(reply_date__range=(start_time, end_time), user=u).values(
            'reply_date',
            'user_id',
            'diary_id',
            'problem_id',
        )[:restrict['restrict_self_reply']]
        other_reply = tr.filter(reply_date__range=(start_time, end_time)).exclude(user=u).values(
            'reply_date',
            'user_id',
            'diary_id',
            'problem_id',
        )[:restrict['restrict_other_reply']]
        other_vote1 = tv.filter(vote_time__range=(start_time, end_time), is_fake=False).exclude(user=u).values(
            'vote_time',
            'topic_id',
            'user_id',
        )
        other_vote2 = dv.filter(vote_time__range=(start_time, end_time), is_fake=False).exclude(user=u).values(
            'vote_time',
            'diary_id',
            'user_id',
        )
        other_vote = list(other_vote1) + list(other_vote2)
        other_vote = sorted(other_vote, key=lambda x: x['vote_time'])[:restrict['restrict_other_vote']]
        return list(create_topic), list(modify_diary), list(self_reply), list(other_reply), list(other_vote)
