# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.models.diary.diary import Diary
from talos.services.tag import TagService


class DiaryTag(models.Model):
    class Meta:
        app_label = 'talos'
        db_table = 'api_diary_tags'

    diary = models.ForeignKey(Diary)
    tag_id = models.IntegerField()

    def __unicode__(self):
        return "%s:%d" % (self.tag_id, self.diary_id)

    @classmethod
    def create_bind(cls, diary_id, tag_id):
        diary_exists = Diary.objects.filter(id=diary_id).exists()
        tag_exists = TagService.get_tag_by_tag_id(id=tag_id) is not None
        if diary_exists and tag_exists:
            dt = cls()
            dt.diary_id = diary_id
            dt.tag_id = tag_id
            dt.save()
            return True
        else:
            return False


class DiaryTagV3(models.Model):
    class Meta:
        db_table = 'api_diary_tag_v3'
        app_label = "talos"

    diary_id = models.IntegerField(verbose_name="日记本id", db_index=True)
    tag_v3_id = models.IntegerField(verbose_name="标签V3", db_index=True)
