
from django.db import models
from django.utils import timezone

from gm_types.gaia import DOCTOR_PROCESS_STATUS

from talos.models.diary.diary import Diary
from talos.models.topic.topic import Problem
from qa.models.answer import Question


class DoctorMessageList(models.Model):
    """医生后台-用户管理、客户日记列表"""

    class Meta:
        db_table = 'api_doctor_question_diary'
        app_label = 'talos'

    question = models.ForeignKey(Question, null=True, verbose_name='关联的问题')
    diary = models.ForeignKey(Diary, null=True, verbose_name='关联的日记本')
    topic = models.ForeignKey(Problem, null=True, verbose_name='关联的日记本帖')
    user_id = models.IntegerField(verbose_name=u'作者id')
    doctor_id = models.CharField(max_length=100, null=True, blank=True, verbose_name=u'关联的医生id', db_index=True)
    created_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now, db_index=True)
    is_online = models.BooleanField(verbose_name='是否在线', default=True)
    process_status = models.CharField(max_length=1, default=DOCTOR_PROCESS_STATUS.unprocessed,
                                      choices=DOCTOR_PROCESS_STATUS, null=False, verbose_name=u"处理状态")
