from django.db import models

from gm_types.mimas.enum import ATTENTION_NOTIFY_TYPE


class FollowMsgNotification(models.Model):
    """
    关注的用户发布动态， 粉丝在 消息-关注页 会看到动态展示
    """
    class Meta:
        verbose_name = u'消息页-关注 消息'
        db_table = 'api_followmsgnotification'

    user_id = models.IntegerField(verbose_name=u'被关注人id', db_index=True)
    fans_id = models.IntegerField(verbose_name=u'粉丝id', db_index=True)
    create_time = models.DateTimeField(auto_now_add=True)
    update_time = models.DateTimeField(auto_now=True)
    is_read = models.BooleanField(verbose_name='是否已读', default=False)
    is_online = models.BooleanField(verbose_name='是否有效', default=True)
    source_type = models.CharField(verbose_name='消息通知类型', max_length=2, choices=ATTENTION_NOTIFY_TYPE, default='')
    business_id = models.IntegerField(verbose_name='内容id(日记本id,问题id等)', default=0)
