#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.utils import timezone

from gm_types.mimas import (
    TRACTATE_STATUS,
    TRACTATE_CONTENT_LEVEL,
)


class SoftArticleCheck(models.Model):
    """
    新帖子（软文）审核相关
    """
    class Meta:
        verbose_name = u'新帖子软文id审核'
        db_table = 'api_softarticle_check'
        app_label = 'talos'

    softarticle_id = models.IntegerField(verbose_name="软文id", db_index=True)
    user_id = models.IntegerField(verbose_name=u"审核人id", null=True, default=0)
    content_level = models.CharField(verbose_name=u'内容分级', max_length=12, choices=TRACTATE_CONTENT_LEVEL,
                                     default=TRACTATE_CONTENT_LEVEL.NULL)
    status = models.CharField(verbose_name=u"审核状态", max_length=12, choices=TRACTATE_STATUS)  # 通过 or 拒绝 需要将状态同步到帖子表中
    check_content = models.TextField(verbose_name=u'运营审核备注', default='')
    check_time = models.DateTimeField(verbose_name=u'审核时间', default=timezone.now)
    is_online = models.BooleanField(verbose_name=u'运营控制是否上线', default=False)
    online_time = models.DateTimeField(verbose_name=u'运营上下线时间', null=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)