# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from gm_types.gaia import HOSPITAL_TYPE
from gm_types.doctor import HOSPITAL_LEVEL

from talos.services.models.base import ServiceModelBase
from talos.rpc import RPCMixin


class Hospital(RPCMixin, ServiceModelBase):

    __slots__ = [
        'id',
        'name',
        'hospital_type',
        'hospital_level',
        'city_tag_id',
        'province_tag_id',
        'country_tag_id',
    ]

    _auto_type_map_ = [
        ('name', str, u''),
        ('city_tag_id', int, None),
        ('province_tag_id', int, None),
        ('country_tag_id', int, None),
        ('hospital_type', str, HOSPITAL_TYPE.PUBLIC),
        ('hospital_level', int, HOSPITAL_LEVEL.NONE),
    ]

    def __init__(self, id, name, city_tag_id=None, province_tag_id=None, country_tag_id=None,
                 hospital_type=HOSPITAL_TYPE.PUBLIC, hospital_level=HOSPITAL_LEVEL.NONE):
        self.id = id
        self.name = name
        self.hospital_type = hospital_type
        self.hospital_level = hospital_level
        self.city_tag_id = city_tag_id
        self.province_tag_id = province_tag_id
        self.country_tag_id = country_tag_id

    def __bool__(self):
        return self.id is not None

    __nonzero__ = __bool__
