-- Deploy mimas-talos:talos_2020_09_15_create_table_api_topic_aggregate to mysql

BEGIN;

CREATE TABLE `api_topic_aggregate` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `topic_id` int(11) NOT NULL COMMENT '帖子id',
    `real_comment_num` int(11) NOT NULL DEFAULT 0 COMMENT '真实评论数',
    `is_deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否被删除',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_topic_id` (`topic_id`),
    KEY `idx_real_comment_num` (`real_comment_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='帖子聚合数据';

COMMIT;
