# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function

import datetime
import re

from django.conf import settings
from celery import shared_task
from gm_types.gaia import DIARY_ORDER_TYPE, REPORT_TYPE, REPORT_REASON

from talos.models.topic import TopicReply
from talos.models.report import Report
from talos.services.tag import TagService


@shared_task
def preload_tags():
    TagService.preload_tags()


@shared_task
def mark_reply_spam():
    """
     将疑似广告帖作为一个类型的举报
    :return:
    """
    topicreply = TopicReply.objects.filter(
        reply_date__gte=datetime.date.today()
    ).exclude(user_id=settings.SUOZHANG_UID)
    filter_words = [u'qq', u'QQ', u'weixin', u'vx', u'网赚', u'加V', u'微我', u'私聊', u'網絡', u'曰结',
                    u'工資', u'➕Q', u'Q聊', u'Vx', u'煎职', u'搛植', u'v信', u'工姿']
    num_list = [u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9', u'0', u'一', u'二', u'三', u'四', u'五',
                u'六', u'七', u'八', u'九', u'十', u'零', u'③', u'⑨', u'⑤', u'⑧', u'⑦', u'壹']

    for tr in topicreply:
        word = 0
        for item in tr.content:
            word += num_list.count(item)
        if re.findall(u"\d{5,}", tr.content) or any(word in tr.content for word in filter_words) or word >= 5:
            tr.is_spam = True
            tr.save()
            report = Report()
            report.topic_reply = tr
            report.type = REPORT_TYPE.REPLY
            report.reason = REPORT_REASON.SPAM
            report.user_id = settings.SUOZHANG_UID
            report.save()
