from multiprocessing import Manager, Pool

from .init_user_rights_base import *



@trace_unhandled_exceptions
def process_answer_recommended(line):
    _d = json.loads(line)
    # 剔除脏数据
    if not _d['author_id']:
        return

    if _d['type'] == 'question':
        push_event(event_type=EventType.QUESTIONRECOMMENDED,
                       trigger_time=time.time(),
                       user_id=_d['author_id'], item_id=_d['question_id'])

    elif _d['type'] == 'answer':
        push_event(event_type=EventType.ANSWERRECOMMENDED,
                       trigger_time=time.time(),
                       user_id=_d['author_id'], item_id=_d['answer_id'])


class Command(BaseCommand):

    def handle(self, *args, **options):
        # answer
        print('------start-----')
        start_time = time.time()
        print(start_time)

        with open(path_base + 'answer_infos.txt', 'r') as f:
            lines = f.readlines()

            pool = Pool(processes=4)
            pool.map(process_answer_recommended, lines)
            pool.close()
            pool.join()

        end_time = time.time()
        print(end_time)
        print('use {} s'.format(end_time - start_time))
        print('Done!')





