#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db.models import Q


class BaseManager(object):
    model = None  # 必填
    base_query = Q()

    @staticmethod
    def filter_ids(ids):
        return set(map(int, filter(None, ids)))

    @staticmethod
    def get_objs_by_query_and_order(model, query, order_by=[]):
        """
        获取 query_set对象
        :param model:
        :param query:
        :param order_by:
        :return:
        """
        _queryset = model.objects.filter(
            query).order_by(*order_by)

        return _queryset

    def get_objs_by_ids(self, _ids):
        """
        通过id获取对象, 内部的方法
        :param _ids:
        :return:
        """
        _ids = self.filter_ids(_ids)
        query = Q(pk__in=_ids) & self.base_query

        return self.get_objs_by_query_and_order(self.model, query=query, order_by=[])
