from qa.service import AnswerReplyService
from talos.rpc import bind
from talos.services.tractate import TractateReplyService
from utils.group_routine import GroupRoutine


@bind('mimas/group/reply_count')
def get_group_reply_count(diary_ids, answer_ids, tractate_ids):
    """统计话题、小组下关联内容的评论总数"""
    total_count = 0
    routine = GroupRoutine()
    for answer_id in answer_ids:
        routine.submit('a_' + str(answer_id), AnswerReplyService.get_reply_count, answer_id)
    for tractate_id in tractate_ids:
        routine.submit('t_' + str(tractate_id), TractateReplyService.get_reply_count_by_tractate_id, tractate_id)
    routine.go()

    for answer_id in answer_ids:
        total_count += routine.results.get('a_' + str(answer_id), 0)

    for tractate_id in tractate_ids:
        total_count += routine.results.get('t_' + str(tractate_id), 0)

    return {
        'total_count': total_count
    }
