# -*- coding: UTF-8 -*-
import json
import requests
import math
import time
import queue

from django.core.management import BaseCommand
from django.conf import settings
from django.db.models import Q, Max
from gm_types.mimas.enum import IMAGE_TYPE

from qa.models import QuestionImage, AnswerImage
from qa.utils.image import img_type, handle_image_type


answer_img_queue = queue.Queue()
max_answer_img_info = AnswerImage.objects.order_by("id").last()
question_img_queue = queue.Queue()
max_question_img_info = QuestionImage.objects.order_by("id").last()


class UpdateQaImgType(object):
    step = 200

    def qa_image_update(self, qa_images):
        """处理图片内容类型"""
        for qa_image in qa_images:
            if not qa_image:
                qa_image.image_type = IMAGE_TYPE.OTHER
                qa_image.save()
                continue

            import json
            if not qa_image.image_url:
                qa_image.image_type = IMAGE_TYPE.OTHER
                qa_image.save()
                continue
            try:
                request_url = qa_image.image_url.replace("https", 'http') + "-imageinfo"
                resp = requests.get(request_url, timeout=10)
                img_res = json.loads(resp.text)
                item_type = img_type.get(img_res.get("format"), IMAGE_TYPE.OTHER) or IMAGE_TYPE.OTHER
                qa_image.image_type = item_type
                qa_image.save()
                print("图片信息地址", qa_image.id, request_url)
            except:
                continue

        return

    def handle_question(self):
        last_question_id = question_img_queue.get()

        if max_question_img_info.id <= last_question_id:
            question_img_queue.put(last_question_id)
            return

        print("当前执行的问答ID=======目标问答ID", last_question_id, max_question_img_info.id)
        per_num = 200

        q_imgs = QuestionImage.objects.filter(id__gt=last_question_id)[:per_num]
        max_id = q_imgs.aggregate(max_id=Max('id'))
        question_img_queue.put(max_id.get('max_id'))
        self.qa_image_update(qa_images=q_imgs)

    def handle_answer(self):
        last_answer_id = answer_img_queue.get()

        if max_answer_img_info.id <= last_answer_id:
            answer_img_queue.put(last_answer_id)
            return

        print("当前执行的问答ID=======目标问答ID", last_answer_id, max_answer_img_info.id)
        per_num = 200

        a_imgs = AnswerImage.objects.filter(id__gt=last_answer_id)[:per_num]
        max_id = a_imgs.aggregate(max_id=Max('id'))
        answer_img_queue.put(max_id.get('max_id'))
        self.qa_image_update(qa_images=a_imgs)


class Command(BaseCommand):
    step = 200

    def handle(self, *args, **kwargs):

        update_action = UpdateQaImgType()

        q_count = QuestionImage.objects.order_by("id").count()
        q_range = math.ceil(float(q_count) / 200)
        question_img_queue.put(0)
        for i in range(q_range):
            update_action.handle_question()

        a_count = AnswerImage.objects.order_by("id").count()
        a_range = math.ceil(float(a_count) / 200)
        answer_img_queue.put(0)
        for i in range(a_range):
            update_action.handle_answer()



