# coding:utf-8

import re

from django.core.management import BaseCommand, CommandError

from qa.models import Question, Answer


class Command(BaseCommand):

    def handle(self, *args, **options):

        for answer in Answer.objects.filter(pk__gt=545281):
            content = answer.content
            content = content.replace("<noscript>", '')
            content = content.replace("</noscript>", '')
            content = content.replace("谢邀。", '')
            for match in re.finditer(r'<img\ssrc="data\:image\/svg\+xml.*?\/>', content):
                if match.group():
                    content = content.replace(match.group(), '')

            answer.content = content
            answer.save()
