# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.utils import timezone
from gm_types.mimas import GRABBING_PLATFORM, ASSESSMENT_TYPE
from gm_upload import ImgUrlField, IMG_TYPE


class KolQuestion(models.Model):
    class Meta:
        verbose_name = u'pgc内容问题'
        app_label = u'api'

    platform = models.CharField(u'平台信息', max_length=2, choices=GRABBING_PLATFORM)
    original_id = models.CharField(u'问题原id', max_length=128, null=True)
    create_time = models.DateTimeField(u'问题创建时间')
    update_time = models.DateTimeField(u'问题更新时间')
    title = models.CharField(u'问题内容', max_length=128)
    author_name = models.CharField(u'问题作者名', max_length=128)
    author_headline = models.CharField(u'问题作者简介', max_length=256)
    author_token = models.CharField(u'问题用户身份令牌', max_length=128)
    #根据question_id判断是否审核
    question_id = models.IntegerField(u'审核后的问题id', null=True)
    vast_id = models.IntegerField(u'马甲用户id', null=True)
    review_time = models.DateTimeField(u'审核时间', auto_now=True)
    catch_time = models.DateTimeField(u'捕获时间', auto_now_add=True)


class KolAnswer(models.Model):
    class Meta:
        verbose_name = u'pgc内容回答'
        app_label = u'api'

    platform = models.CharField(u'平台信息', max_length=2, choices=GRABBING_PLATFORM)
    original_id = models.CharField(u'回答原id', max_length=128, null=True)
    create_time = models.DateTimeField(u'回答创建时间', default=timezone.now)
    update_time = models.DateTimeField(u'回答更新时间', auto_now=True)
    content = models.TextField(u'回答内容')
    author_name = models.CharField(u'回答作者名', max_length=128)
    author_headline = models.CharField(u'回答作者简介', max_length=256)
    author_token = models.CharField(u'回答用户身份令牌', max_length=128)
    kol_question_id = models.IntegerField(u'原问题id')
    # v 7.6.75 pgc抓取新增字段
    author_id = models.IntegerField("作者对应的用户id", null=True)
    author_portrait = ImgUrlField(img_type=IMG_TYPE.USEREXTRA, verbose_name='作者对应的头像', max_length=100,
                                  null=True, default="")
    title = models.CharField(u"抓取内容标题", max_length=256, null=True)
    ask = models.CharField(u"抓取内容简介", max_length=256, null=True)
    vote_num = models.IntegerField("原点赞数", default=0)
    comment_num = models.IntegerField("原评论数", default=0)
    share_num = models.IntegerField("原分享数", default=0)
    tags = models.TextField(verbose_name=u"pgc关联标签", default='[]')  # json类型数据 '["tag1", "tag2"]'
    cover_images = models.TextField(verbose_name=u"pgc对应封面", default='[]')  # json类型数据 '["http://xx", ""]'

    # 根据answer_id判断是否审核
    answer_id = models.IntegerField(u'审核后的回答id', null=True)
    question_id = models.IntegerField(u'问题id', null=True)
    vast_id = models.IntegerField(u'马甲用户id', null=True)
    review_time = models.DateTimeField(u'审核时间', auto_now=True)
    catch_time = models.DateTimeField(u'捕获时间', auto_now_add=True)
    check_type = models.CharField(u'审核类型', max_length=2, choices=ASSESSMENT_TYPE)

    # 当审核为专栏时,需要保存审核通过后的专栏ID
    article_id = models.CharField(u'专栏id', max_length=256, null=True)


class KolAnswerRelationTag(models.Model):
    class Meta:
        verbose_name = u'pgc内容回答关联标签'
        app_label = "qa"
        db_table = "api_kolanswer_relation_tag"

    kol_answer_id = models.IntegerField("pgc内容回答索引id", db_index=True)
    tag_id = models.IntegerField("标签id", db_index=True)
