# -*- coding: utf-8 -*-

from django.db.models.signals import post_save, post_delete
from django.dispatch import receiver
from helios.rpc import RPCFaultException

from qa.cache import vote_cache
from qa.cache.manager import AnswerSortCacheManager
from qa.models import Answer
from qa.models import AnswerVote, UserAnswerQuestion, Question, AnswerReply
from utils.rpc import rpc_client
from qa.utils.vote import VoteTool
from qa.models import AnswerReply, AnswerVoteReply
from talos.tools.vote_tool import VoteTool as NewVoteTool
from talos.cache.base import vote_cache as new_vote_cache

from talos.portal import create_reply_collect

from gm_types.gaia import REPLYOBJECT
from talos.cache.base import reply_cache as reply_msg_cache
from talos.tools.replies_tool import ReplyTool


@receiver(post_save, sender=AnswerVote)
def topicvote_post_save(sender, instance, created, **kwargs):
    vt = VoteTool(vote_cache, instance.answer.user_id)
    vt.receive_answer_vote(instance.id)

    vt_v1 = NewVoteTool(new_vote_cache, instance.answer.user_id, new_version=True)
    vt_v1.receive_answer_vote(instance.id)


@receiver(post_delete, sender=AnswerVote)
def topicvote_post_delete(sender, instance, **kwargs):

    vt = NewVoteTool(new_vote_cache, instance.answer.user_id, new_version=True)
    vt.remove_answer_vote(instance.id)


@receiver(post_save, sender=Answer)
def answer_post_save(sender, instance, created, **kwargs):
    if created:
        UserAnswerQuestion.objects.create(user=instance.user_id, answer=instance)

        try:
            user_id = instance.question.user_id
            if instance.user_id != user_id:
                rt = ReplyTool(reply_msg_cache, user_id)
                rt.receive_answer(instance.id)
        except:
            pass

        return

    if not created:
        UserAnswerQuestion.objects.filter(answer_id=instance.id).update(is_online=instance.is_online)

    try:
        if 'is_online' in kwargs['update_fields']:
            manager = AnswerSortCacheManager()
            manager.calc_cache(instance.question_id)
    except:
        pass


@receiver(post_save, sender=AnswerReply)
def answer_reply_post_save(sender, instance, created, **kwargs):
    if not created:
        return

    # if instance.is_read:
    #     return

    if instance.commented_reply_id:
        reply_user_id = instance.commented_reply.user_id
    else:
        reply_user_id = instance.answer.user_id

    create_reply_collect(
        create_time=str(instance.create_time),
        user_id=instance.user_id,
        topic_id=None,
        answer_id=instance.id,
        reply_user_id=reply_user_id
    )

    if reply_user_id == instance.user_id:
        return

    rt = ReplyTool(reply_msg_cache, reply_user_id)
    rt.receive_answer_reply(instance.id)


@receiver(post_save, sender=Question)
def question_create_post_save(sender, instance, created, **kwargs):

    if created:
        UserAnswerQuestion.objects.create(user=instance.user_id, question=instance)
    else:
        UserAnswerQuestion.objects.filter(question_id=instance.id).update(is_online=instance.is_online)


@receiver(post_save, sender=AnswerVoteReply)
def answer_reply_vote_post_save(sender, instance, created, **kwargs):

    vt_v1 = NewVoteTool(new_vote_cache, instance.answerreply.user_id, new_version=True)
    vt_v1.receive_answer_reply_vote(instance.id)
