#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_types.mimas import (
    PUSH_ACTION_TYPE,
)
from gm_types.user_hierarchy import EventType

from communal.tools import PushService
from qa.models import (
    Answer,
    AnswerVote,
)
from talos.tools.vote_tool import VoteTool as NewVoteTool
from talos.cache.base import vote_cache as new_vote_cache
from utils.rpc import (
    gen,
    rpc_client,
    logging_exception,
)
from user_hierarchy.portal import process_task


class AnswerVoteCreateMethod(object):
    """
    回答点赞创建
    """

    @staticmethod
    def create_answer_vote(create_data, answer_obj):
        """
        回答创建
        :param create_data:
        :param answer_obj:
        :return:
        """
        answer_vote, created = AnswerVote.objects.get_or_create(**create_data)
        if created:
            answer_obj.like_num += 1
            answer_obj.save()

        return {
            "answer_vote_obj": answer_vote,
            "created": created,
        }

    @staticmethod
    def various_logic_after_answer_vote_create(answer_user_id, answer_vote_obj, created=False):
        """
        回答点赞 创建完之后走的逻辑
        :param answer_user_id:
        :param answer_vote_obj:
        :param created:
        :return:
        """
        if created:
            vt_v1 = NewVoteTool(new_vote_cache, answer_user_id, new_version=True)
            vt_v1.receive_answer_vote(answer_vote_obj.id)

            rpc_client['api/person/incr_vote'](user_id=answer_user_id).unwrap()

            # 成长值相关
            event_data = process_task(
                user_id=answer_vote_obj.user_id,
                event_type=EventType.VOTE_MULTI_TIMES,
                related_item=answer_vote_obj.id
            )

    @staticmethod
    def trigger_tasks_after_answer_vote_create(answer_obj, user):
        """
        回答点赞完后，触发的异步任务
        :param answer_obj:
        :param user:
        :return:
        """
        valid_user_ids = PushService.filter_valid_user_ids([answer_obj.user_id], filter_user_id=user.id)
        PushService.push(
            user_ids=valid_user_ids,
            action_type=PUSH_ACTION_TYPE.ANSWER_RECV_VOTE,
            nick_name=getattr(user, "nick_name", "") or getattr(user, "nickname", ""),
            answer_id=answer_obj.id,
            content=answer_obj.content,
            question_id=answer_obj.question_id
        )
        # TODO 先不触发用户行为埋点

    @classmethod
    def answer_vote_create(cls, user, answer_id, **kwargs):
        """
        回答点赞
        :param user:
        :param answer_id:
        :return:
        """
        answer_obj = Answer.objects.filter(pk=answer_id).first()
        create_info = cls.create_answer_vote(
            create_data={
                "user": user.id,
                "answer_id": answer_id,
                "is_fake": kwargs.get("is_fake", False)
            },
            answer_obj=answer_obj
        )

        cls.various_logic_after_answer_vote_create(
            answer_user_id=answer_obj.user_id,
            answer_vote_obj=create_info["answer_vote_obj"],
            created=create_info["created"]
        )

        cls.trigger_tasks_after_answer_vote_create(
            answer_obj=answer_obj,
            user=user
        )