# coding=utf-8

from __future__ import absolute_import

from django.conf import settings
from gm_types.gaia import USER_RIGHTS_LEVEL, MEMBERSHIP_LEVEL

from utils.rpc import rpc_client
from qa.utils.image import get_thumb_path


def get_user_level(user):
    if not user:
        return {
            'membership_icon': settings.MEMBERSHIP_IMG[MEMBERSHIP_LEVEL.NORMAL],
            'level_icon': settings.LEVEL_IMG[USER_RIGHTS_LEVEL.V1],
            'constellation_icon': '',
        }
    return {
        'membership_icon': user.membership_icon,
        'level_icon': user.level_icon,
        'constellation_icon': user.constellation_icon,
    }


def filter_user_nick_name(user):
    """
    获取指定用户的昵称
    函数定义已复制到passport项目, 如需修改请联系passport负责人
    @param user:
    @return:
    """
    if not user:
        return u''

    if user.last_name:
        return user.last_name

    username = user.username
    if len(username) == 11:
        return username
    else:
        return username[:8]


def get_portrait_by_user(user):
    """"""
    if user.userextra and user.userextra.portrait:
        portrait = get_thumb_path(user.userextra.portrait)
    else:
        portrait = get_thumb_path(u'img%2Fuser_portrait.png')
    return portrait


def get_auth_type_by_userid(uid):
    """

    :param uid:
    :return:
    """
    from talos.cache.base import user_auth_type_cache

    k = str(uid)
    res = user_auth_type_cache.get(k)
    if res:
        return res

    res = rpc_client['api/user/auth_type'](uid=uid).unwrap()
    user_auth_type_cache.set(k, res)
    user_auth_type_cache.expire(k, 60 * 60 * 24 * 7)

    return res
