#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
__title__ = ''
__author__ = 'xierong@gmei.com'
__mtime__ = '18/4/3'
'''

from django.db import models
from gm_types.gaia import INDEX_CARD_TYPE
from gm_types.mimas.qa import CONTENT_CLASS


class MixIndex(models.Model):
    class Meta:
        app_label = 'talos'
        db_table = 'mixed_index'
        verbose_name = u'优秀良好问答及专栏-新圈子知识tab'

    original_id = models.IntegerField(verbose_name=u"数据源id")
    original_type = models.CharField(verbose_name=u'数据类型', max_length=2, choices=INDEX_CARD_TYPE)
    original_create_time = models.DateTimeField(verbose_name=u'数据源的创建时间')
    answer_is_recommend = models.BooleanField(verbose_name='回答是否推荐', default=False)
    answer_score = models.FloatField(verbose_name='推荐类回答的得分', blank=True, default=0.0)


class MixIndexTag(models.Model):
    class Meta:
        app_label = 'talos'
        db_table = 'mixed_index_tag'
        verbose_name = u'新圈子知识tab项目与tag关系'

    mix_index = models.ForeignKey(MixIndex)
    tag_id = models.IntegerField()