#!/usr/bin/env python
# -*- coding: utf-8 -*-
import uuid
from datetime import timedelta, date

from celery.schedules import crontab
from gm_types.gaia import USER_RIGHTS_LEVEL, MEMBERSHIP_LEVEL

DATABASES = {
    'default': {  # mysql
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'mimas_test',
        'USER': 'work',
        'PASSWORD': 'workwork',
        'HOST': 'rdsmaqevmuzj6jy.mysql.rds.aliyuncs.com',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    }
}
CELERY_TIMEZONE = 'Asia/Shanghai'
BROKER_URL = 'redis://127.0.0.1:6379/0'
CELERY_TASK_SERIALIZER = "json"
SENTRY_CELERY_ENDPOINT = ''

BACKEND_API_HOST = 'https://backend.igengmei.com'

# 初始化数据
INIT_DATA = False

REDIS_CONF = {'host': 'test-redis', 'port': 6379, 'db': 0}

# qa hack num
SUOZHANG_UID = 22

ANSWER_HACK_STRT = '-'

QINIU_CDN_HOST = u'https://pic.igengmei.com/'

MULTI_TOPIC_TAG_ID = 5089

GM_SERIALIZER = {
    'redis': {
        'host': '127.0.0.1', 'port': 6379, 'db': 1
    }
}

TEST_RUNNER = 'gm_test.runner.GmTestRunner'

REDIS = {
    'default': {'host': '127.0.0.1', 'port': 6379, 'db': 0},
    'view': {'host': '127.0.0.1', 'port': 6379, 'db': 1},
    'answer_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'answer_sort_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'high_quality_question_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 5},
    'vote_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 6},
    'user_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 5},
}

DATABASE_ROUTERS = ['utils.router.ThreadLocalRouter','utils.router.DorisRouter']

REDIS_MIGRATE = (
    {
        # gaia view_cache addr.
        'source': {'host': '127.0.0.1', 'port': 7777, 'db': 1},
        'prefix': ('question_view', 'answer_view'),
        'target': REDIS['view']
    },
    {
        # gaia answer_sort_cache addr:
        'source': {'host': '127.0.0.1', 'port': 7777, 'db': 2},
        'prefix': ('answer_sort_cache',),
        'target': REDIS['answer_sort_cache']
    },
    {
        # gaia vote_cache addr.
        'source': {'host': '127.0.0.1', 'port': 7777, 'db': 2},
        'prefix': ('vote_cache',),
        'target': REDIS['vote_cache']
    },
)
# topic 迁移一期,暂时共用gaia redis
REDIS_TOPIC_1ST = {
    'default': {'host': 'redis.test.gengmei', 'port': 6379, 'db': 14},  # gaia settings.DEFAULT_REDIS
    'view': {'host': 'test-redis', 'port': 6379, 'db': 2},  # gaia settings.REDIS['view']
    'talos_rpc_cache': {'host': 'redis.test.gengmei', 'port': 6379, 'db': 14},  # gaia settings.TALOS_RPC_CACHE
    'user_cache': {'host': 'test-redis', 'port': 6379, 'db': 5},  # gaia settings.REDIS['user_cache']
    'page_cache': {'host': 'test-redis', 'port': 6379, 'db': 15},  # gaia settings.REDIS['page_cache']
    'vote_cache': {'host': 'test-redis', 'port': 6379, 'db': 11},  # gaia settings.REDIS['vote_cache']
    'reply_cache': {'host': 'test-redis', 'port': 6379, 'db': 11},
    'favor_cache': {'host': 'test-redis', 'port': 6379, 'db': 12},
    'tractate_pv_cache': {'host': 'test-redis', 'port': 6379, 'db': 12},
    'tractate_reply_cache': {'host': 'test-redis', 'port': 6379, 'db': 12},
    'tractate_pgc_cache': {'host': 'test-redis', 'port': 6379, 'db': 12},
}
REDIS_MIGRATE_TALOS = (
    {
        # gaia REDIS view addr.
        'source': {'host': '127.0.0.1', 'port': 7777, 'db': 1},
        'prefix': ('diary_pv',),
        'target': REDIS['view']
    },
)

ONCE = {
  'backend': 'celery_once.backends.Redis',
  'settings': {
    'url': BROKER_URL,
    'default_timeout': 60 * 60 * 24
  }
}

BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 60 * 60 * 24 * 3}

CELERY_ROUTES = ['settings.celery_task_router.CeleryTaskRouter']
CELERYBEAT_SCHEDULE = {
    "build_high_quality_cache": {
        'task': 'qa.tasks.answer.build_high_quality_cache',
        'schedule': timedelta(seconds=3600),
        'args': (),
    },
    # 轮训七牛转码状态
    'check_water_mark_video_is_finish': {
        'task': 'live.tasks.check_water_mark_video_is_finish',
        'schedule': timedelta(seconds=300),
        'args': (),
    },

    # 日记帖 轮训video状态，生成webP使用 可和下方两个统一
    'video_fsm_runner': {
        'task': 'live.tasks.video_fsm_runner',
        'schedule': timedelta(minutes=10),
        'args': (),
    },

    # 新帖子 轮训tractate_video状态，生成webP使用
    'tractate_video_fsm_runner': {
        'task': 'talos.tasks.tractate.tractate_video_fsm_runner',
        'schedule': timedelta(minutes=10),
        'args': (),
    },

    # 富文本 轮训video_cover状态，生成webP使用
    'video_cover_fsm_runner': {
        'task': 'qa.tasks.get_video_blurcover.video_cover_fsm_runner',
        'schedule': timedelta(minutes=10),
        'args': (),
    },

    # 生成直播回放帖子
    'save_replay_url': {
        'task': 'live.tasks.save_replay_url',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    # 直播状态检查
    'check_live_status': {
        'task': 'live.tasks.check_live_status',
        'schedule': timedelta(minutes=2),
        'args': (),
    },

    'add_fake_vote_num_list': {
        'task': 'live.tasks.add_fake_vote_num_list',
        'schedule': timedelta(minutes=1),
        'args': (),
    },
    "live_add_live_robot": {
        "task": "live.tasks.add_live_robot",
        "schedule": timedelta(seconds=10),
        "args": (),
    },
    # 已无调用 180411
    # v 7.6.65 更改 该功能不再使用！
    # 'hot_in_24hrs': {
    #     'task': 'talos.tasks.topic.hot_in_24hrs',
    #     'schedule': crontab(minute=0, hour='9,12,21'),
    #     'args': ()
    # },
    # 统计crash相关关键字帖子
    'crash_checkout': {
        'task': 'talos.tasks.crash_checkout.crash_check',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 他人主页推荐关注的用户
    'create_high_quality_user_to_redis': {
        'task': 'talos.tasks.diary.create_high_quality_user_to_redis',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 提醒用户更新日记
    "remind_user_to_update_diary": {
        'task': 'talos.tasks.diary.remind_user_to_update_diary',
        'schedule': crontab(day_of_month="*", hour="19", minute=0),
        'args': ()
    },
    # 计算帖子热度分数
    'calc_topic_ranking': {
        'task': 'talos.tasks.topic_ranking.calc_topic_ranking',
        'schedule': crontab(hour=5, minute=0),  # hour should be exactly the same as TopicRankingScore.SPLIT_HOUR
        'args': (),
    },
    'doctor_diary_tags': {
        'task': 'talos.tasks.diary.doctor_diary_tags',
        'schedule': crontab(minute=30, hour='6'),
        'args': ()
    },
    # 非日记帖，同步成问答
    'convert_topic_to_question': {
        'task': 'talos.tasks.topic.move_topic_to_answer',
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },
    'get_index_diary_detail': {
        'task': 'talos.tasks.diary.get_index_diary_detail',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 'fake_vote_to_topics': {
    #     'task': 'talos.tasks.topic.fake_vote_to_topic',
    #     'schedule': crontab(minute=0, hour='0,8-23'),
    #     'args': (),
    # },
    # 记录邀请人user_id列表池
    'build_inviter_pool': {
        'task': "qa.tasks.answer.build_inviter_pool",
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },
    # 每天下午5点，定时推送被邀请回答的用户，累计被邀请的次数。
    'time_push_to_invited_user': {
        'task': "qa.tasks.answer.time_push_to_invited_user",
        'schedule': crontab(hour=17, minute=0),
        'args': (),
    },
    'take_sofa_diary': {
        'task': 'talos.tasks.diary.take_sofa_diary',
        'schedule': timedelta(minutes=20),
        'args': (),
    },
    'default_diary_rating': {
        'task': 'talos.tasks.diary.default_diary_rating',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'mark_reply_spam': {
        'task': 'talos.tasks.period_tasks.mark_reply_spam',
        'schedule': crontab(minute=50, hour=23),
        'args': (),
    },
    # 抓取微信公众号数据
    'get_wechat_pgc': {
        'task': 'talos.tasks.topic.get_wechat_pgc',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'rerun_wechat_pgc': {
        'task': 'talos.tasks.topic.rerun_pgc',
        'schedule': crontab(hour='*/3', minute=0),
        'args': (),
    },
    'preload_operation_tags': {
        'task': 'talos.tasks.period_tasks.preload_tags',
        'schedule': timedelta(minutes=60),
        'args': (),
    },
    'hospital_topics_nums': {
        'task': 'talos.tasks.diary.hospital_topics_num',
        'schedule': timedelta(hours=5),
        'args': (),
    },

    # 早上五点进行pv同步
    'sync_diary_pv': {
        'task': 'talos.tasks.diary.update_diary_pv',
        'schedule': crontab(minute=0, hour=5),
        'args': (),
    },
    # 每两个小时计算一次推荐问题数据
    "get_relation_college_tag_questions": {
        "task": "qa.tasks.answer.get_relation_college_tag_questions",
        "schedule": timedelta(hours=3),
        "args": (),
    },
    "gen_sitemap_data": {
        "task": "talos.tasks.sitemap.sitemap",
        "schedule": timedelta(days=3),
        "args": (),
    },

    # 定时刷新处理视频带水印地址
    "check_community_video_water_mark_url_is_finish": {
        "task": "live.tasks.check_community_video_water_mark_url_is_finish",
        "schedule": timedelta(minutes=10),
        "args": (),
    },

    # 替换富文本视频地址
    "convert_rich_text_video_url": {
        "task": "utils.tasks.convert_rich_text_video_url",
        "schedule": timedelta(minutes=30),
        "args": (),
    },

    # 处理新帖子视频数据
    "check_tractate_video_water_mark_url_is_finish": {
        "task": "talos.tasks.tractate.check_tractate_video_water_mark_url_is_finish",
        "schedule": timedelta(minutes=15),
       "args": (),
    },

    # 首页feed冷启动实验刷新
    "refresh_pgc_info": {
        "task": "talos.tasks.tractate.refresh_pgc_info",
        "schedule": timedelta(minutes=15),
        "args": (),
    },

    # 处理医生后台发帖视频数据
    "check_soft_article_video_water_mark_url_is_finish": {
        "task": "talos.tasks.tractate.check_soft_article_video_water_mark_url_is_finish",
        "schedule": timedelta(minutes=15),
        "args": (),
    },
    # 每天早上5点跑日记本灌水点赞
    # "diary_push_timing": {
    #     "task": "talos.tasks.vote.diary_push_timing",
    #     "schedule": crontab(minute=0, hour=5),
    #     "args": (),
    # },
    # 点赞灌水 每天触发
    # "fake_vote_task": {
    #     "task": "talos.tasks.common_fake_vote.fake_vote_task",
    #     "schedule": crontab(minute=0, hour=7),
    #     "args": (),
    # },

    # 基于用户对内容的兴趣进行召回 WIKI: http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=33596077
    "user_interest_in_content_for_callback_top3": {
        "task": "qa.tasks.callback_user_push.user_interest_in_content_for_callback",
        "schedule": crontab(minute=0, hour=9),
        "args": (3, ),
    },
    "user_interest_in_content_for_callback_top2": {
        "task": "qa.tasks.callback_user_push.user_interest_in_content_for_callback",
        "schedule": crontab(minute=0, hour=13),
        "args": (2, ),
    },
    "user_interest_in_content_for_callback_top1": {
        "task": "qa.tasks.callback_user_push.user_interest_in_content_for_callback",
        "schedule": crontab(minute=0, hour=21),
        "args": (1, ),
    },
    # 增量内容标签清洗
    "sync_tag_map_tag3": {
        "task": "talos.tasks.tag_map.sync_tag_map_tag3",
        "schedule": timedelta(hours=4),
        "args": (),
    },
    # 意愿探索标签推送
    "add_device_to_city_map_for_push": {
        "task": "communal.tasks.push_task.add_device_to_city_map_for_push",
        "schedule": crontab(minute=0, hour=5),
        "args": (),
    },
    "parse_personalize_action_task": {
        "task": "communal.tasks.push_task.parse_personalize_action_task",
        "schedule": crontab(minute=0, hour=5),
        "args": (),
    },
    "update_answers_count_of_question": {
        "task": "qa.tasks.get_ctr_device_push_question.update_answers_count_of_question",
        "schedule": crontab(minute=0, hour=5),
        "args": (),
    },
    "record_push_content_of_ctr_device": {
        "task": "qa.tasks.get_ctr_device_push_question.record_push_content_of_ctr_device",
        "schedule": crontab(minute=0, hour=5),
        "args": (),
    },
}

ES_INDEX_PREFIX = 'gm_test'
ES_HOSTS = [
    {'host': '101.200.54.249', 'port': 9200},
    # {'host': 'es2.dev.gengmei', 'port': 9200},
    # {'host': 'es3.dev.gengmei', 'port': 9200},
]
LOGICAL_DATABASE_ID = 'mimas_test'

# listing decorator.
COUNT_LIMIT = 100
VERSION = uuid.uuid1()

QUESTION_SCORE_WEIGHT = {
    'time_score_weight': 1,  #
    'answers_num_score_weight': 1,
    'answer_views_score_weight': 1,
    'answer_likes_score_weight': 1,
    'question_view_score_weight': 1,
    'question_answer_likes_score_weight': 1,
}

DIARY_HEAT_RANK = {
    'lose_rate': 0.006,  # 热度分时间衰减比率  0.006/hour/热度分
    'max_score': 50,  # 最大热度分
    'reply_num_per_device': 3,  # 每设备评论每天限制三次
    # 加分相关
    'score_create_topic': 4,
    'score_modify_diary': 2,
    'score_self_reply': 1,
    'score_other_reply': 1,
    'score_other_vote': 0.5,
    # 限制相关
    'restrict_create_topic': 2,
    'restrict_modify_diary': 1,
    'restrict_self_reply': 10,
    'restrict_other_reply': 15,
    'restrict_other_vote': 20,
}

SEND_MSG_TIME = 2
MSG_POLL_TIME = 4
LIVE_TIME_OUT = 15 * 60
ENTER_MSG_TIME = 0
QINIU_TEMP_CDN_HOST = u'http://pic-tmp.igengmei.com/'
LIVE_MSG_REDIS_FLAG = True
# 直播悬浮窗用户白名单
USE_LIVE_FLOATING_WHITELIST = True

# 网易易盾反垃圾
YD_SECRET_ID = '914c9cb763500c23acdf121faed02c31'
YD_SECRET_KEY = 'ffb43924f88946f7d5b7aac1832a18e5'
YD_BUSINESS_ID = '8034f7ed207ec691c3f30d318e06e0c7'

# 特殊推送限制
SPECTAL_SECONDS_LIMIT = 7200
SPECIAL_PUSH_LIMIT = 4
PUSH_SUB_LIMIT = 1  # 子项，每日只能发一次
PERSON_GET_COMMENT_PUSH_LIMIT = 5  # 评论的每日收到的推送次数

LEVEL_UPPER_GAIN_POINTS = 200  # 每升一等级，增加美分200
USER_EVENT_MULTI_TIMES = 6  # 累计操作次数，给予不同的美分、成长值奖励

POINT_DAILY_LIMIT = 400  # 美分每日上限
GROWTH_DAILY_LIMIT = 300  # 成长值每日上限

UNSHOW_TAGS = [u'美购日记', u'所长精选', u'热门讨论']

# 评论图片和字数限制
CASHBACK_TOPIC_IMAGE_LIMIT = 2
CASHBACK_TOPIC_CONTENT_WORDS_LIMIT = 20
ELITE_LIKE_NUM = 5
HOT_TOPIC_VOTE_THRESHOLD = 10
HOT_TOPIC_VOTE_THRESHOLD_IN_ZONE = 10
REPLIES_READ_MYSQL_FLAG = True

NOTIFICATION_REPLY_IMG = 'https://heras.igengmei.com/2017/07/28/c32ff57e7a'
NOTIFICATION_VOTE_IMG = 'https://heras.igengmei.com/2017/07/28/d7e0c06fb0'

# 检索时间
DAYS_BEFORE_TODAY = -1
# 短视频权限起始等级
CAN_CREATE_VIDEO_LEVEL = USER_RIGHTS_LEVEL.V1
SHOW_VIDEO_COVER = True

HOT_DISCUSSION_TAG_DIARY_SHRESHOLD = 1000
HOT_DISCUSSION_TAG_CONSULT_SHRESHOLD = 30
HOT_DISCUSSION_TAG_DISCUSS_SHRESHOLD = 100

VIDEO_PIC_URL = u'?vframe/jpg/offset/0/rotate/auto'
VIDEO_HOST = u'http://video-static.igengmei.com/'
QINIU_VIDEO_INQUIRE_HOST = 'http://api.qiniu.com/status/get/prefop?id='

FOUNDING_DAY = date(2013, 8, 8)
SOCIAL_REPLY_WEIGHT = 0.7
SOCIAL_LIKE_WEIGHT = 0.3
CONTENT_WEIGHT = 0.4
SOCIAL_WEIGHT = 0.3
TIME_WEIGHT = 0.045

DIARY_COVER_DEFAULT = 'https://heras.igengmei.com/2015/10/16/61b745cb36'

# for SLAVE_DB_NAME
SLAVE_DB_NAME = 'default'
HERA_READ_DB = 'default'

# 邀请人筛选条件，优良回答 总数 > 3
INVITER_LIMIT_FORM_ANSWER = 3
INVITE_QUESTION_LIST_PAGE = "/hybrid/question/question_list"  # 去回答列表页

SUBJECT = u'用户版－用户反馈崩溃日报'
CRASH_KEYWORDS = ['crash', u'闪退', u'软件崩溃', u'软件问题', u'app问题']
SENDTO = ['linli@igengmei.com']
# model中检索的字段
MODEL_FIELDS = {'diary': ['title'], 'problem': ['ask', 'answer'], 'topicreply': ['content']}
# 日记本质量分
DIARY_CONTENT_LEVEL_SCORE = {
    'UNAUDITED': -1000,
    'ILLEGAL': -1000,
    'BAD': -1000,
    'GENERAL': -1000,
    'BETTER': -1000,  # 新增内容等级 3.5，和郑伟确认先按照 -1000给值
    'FINE': 65.0,
    'EXCELLENT': 100.0

}

BUILD_SITEMAP_COUNT = 1000
# rating limit
DIARY_RATING_LIMIT = 2

VIDEO_TAG_ID = 4706  # 如果有小视频 就给日记本添加视频日记的tag
VIDEO_TAG_V3_ID = 2132  # 如果有小视频 就给日记本添加视频日记的tag

# weixin js sdk
# 正式账号
WX_APP_ID = 'wx19c0bdd0c9e25acb'
WX_APP_SECRET = '41855cb5fd32338435b2c7dbaa400716'
WX_USER_ID = 20889703

MIP_LIMIT = 10
# 首页Feed随机比例
DIARY_RANDOM_SCALE = {
    "wuhan": 10,
    "beijing": 15,
    "guangzhou": 10,
    "chengdu": 10,
    "shanghai": 10,
    "chongqing": 10,
    "hangzhou": 10,
    "shenzhen": 10,
}
ANSWER_NUM_BASELINE = 4  # 回答数基本限制

# 计算回答子评论未读数的起始时间
COUNT_ANSWER_COMMENTED_REPLY_START_TIME = '2018-08-15 15:23:00'

DIARY_MATCH_TAG_ID = 7392

# 日记本标签的最大数，用于日记本同步日记帖的判断
DIARY_TAGS_MAX_COUNT = 10

# 视频图片水印地址
# WATER_MARK_URL_FOR_VIDEO = 'https://heras.igengmei.com/2019/03/21/5fc4ad1908'  # 2019.03.21 更美 微整形 logo
WATER_MARK_URL_FOR_VIDEO = 'https://heras.igengmei.com/2019/06/24/8d04d53b15'  # 2019.06.24 更美 医美 logo

# 新帖内容有效字数限制
TRACTATE_CONTENT_MAX_LEN = 1000
TRACTATE_CONTENT_MIN_LEN = 10

ES_HOSTS = [
    # {'host': '192.168.168.142', 'port': 9200},
    {'host': '101.200.54.249', 'port': 9200}
]
VIDEO_CONVERT_PATH = "/tmp/video_convert/"
VIDEO_FF_ARGS = "-vcodec libwebp -lossless 0 -qscale 75 -preset none -loop 0  -vf fps=5 -an -vsync 0"
GIF_CONVERT_PATH ="/tmp/video_convert/"
GIF_FF_WEBP = "-vcodec libwebp -lossless 0 -qscale 60 -preset none -loop 0  -vf fps=5 -an -vsync 0 -ss 00:00:00 -t 2"

MIMAS_LOGICAL_DATABASE_ID = 'mimas_test'

PUSH_RATE_LIMIT_SETTINGS = {
    "start_push_hour": 9,  # 推送开始时间
    "end_push_hour": 23,  # 推送截止时间
    "total_count": 32,  # 总数
    "sub_control": {  # 某类型单位时间内的推送数控制
        "answer_reply": 2,  # 回答评论
        "answer_vote": 1,  # 回答点赞
        "user_follow": 1,  # 用户关注
    }
}

# 达人标示
MEMBERSHIP_IMG = {
    MEMBERSHIP_LEVEL.NORMAL: '',
    MEMBERSHIP_LEVEL.STAR: 'https://heras.igengmei.com/2019/06/27/774d5be861',
}

# 用户权益等级对应图片
LEVEL_IMG = {
    USER_RIGHTS_LEVEL.V1: 'https://heras.igengmei.com/2017/09/18/70ac84d112',
    USER_RIGHTS_LEVEL.V2: 'https://heras.igengmei.com/2017/09/18/fd0d61a201',
    USER_RIGHTS_LEVEL.V3: 'https://heras.igengmei.com/2017/09/18/95f1d286e4',
    USER_RIGHTS_LEVEL.V4: 'https://heras.igengmei.com/2017/09/18/3308232ea5',
    USER_RIGHTS_LEVEL.V5: 'https://heras.igengmei.com/2017/09/18/bbc0d4a0b0',
    USER_RIGHTS_LEVEL.V6: 'https://heras.igengmei.com/2017/09/18/9fe7b12845',
    USER_RIGHTS_LEVEL.V7: 'https://heras.igengmei.com/2017/09/18/445bb6e927',
}

USER_INTEREST_IN_CONTENT_FOR_CALLBACK_GRAY_DEVICE_IDS_ALL_OPEN = True
USER_INTEREST_IN_CONTENT_FOR_CALLBACK_GRAY_DEVICE_IDS = [
    '4010A3D2-B1EA-4FD3-AAA5-73513415C9E7',
    '3E35CDA2-7742-4078-8B46-5F77932D93D8',
    '865712040467593',
    '865277037750070',
]
