# -*- coding: utf-8 -*-

import redis
from django.conf import settings


class ReplyCache(object):
    """cache comments sent and received ids."""

    __pool = redis.ConnectionPool(**settings.REDIS_TOPIC_1ST['user_cache'])
    # __pool = redis.ConnectionPool(**settings.REDIS['user_cache'])
    __cache = redis.Redis(connection_pool=__pool)

    # populate these with user id
    SENT_KEY = 'c_sent:%s'
    RECEIVED_KEY = '%s'

    def get_received_comment_ids(self, user_id):
        k = self.RECEIVED_KEY % user_id
        return self.__cache.smembers(k)

    def get_sent_comment_ids(self, user_id):
        k = self.SENT_KEY % user_id
        return self.__cache.smembers(k)

    # answer_reply answer_reply_xxxxx
    def cache_received_comment_ids(self, user_id, comment_id):
        k = self.RECEIVED_KEY % user_id
        self.__cache.sadd(k, comment_id)

    # answer_reply answer_reply_xxxxx
    def cache_sent_comment_ids(self, user_id, comment_id):
        k = self.SENT_KEY % user_id
        self.__cache.sadd(k, comment_id)


reply_cache = ReplyCache()
