from utils.rpc import rpc_client
import time
from django.core.management.base import BaseCommand
from talos.models.diary import Diary
from gm_types.gaia import DOCTOR_TYPE

hospital_ids=['BJYLHZXMRYY','49a24a1c15b011e6950800163e0051d4']
def clear_somediarys_service():
    doctor_ids=[]
    for doctor_type in DOCTOR_TYPE:
        for hospital_id in hospital_ids:
            doctors=rpc_client['api/hospital/doctor'](hospital_id=hospital_id,doctor_type=doctor_type[0]).unwrap()
            if doctors:
               doctor_ids.extend([doctor["id"] for doctor in doctors if  doctor.get("id")])
    service_ids = rpc_client['doctors/service_id/list'](doctor_ids=doctor_ids).unwrap()

    if service_ids:
       Diary.objects.filter(service_id__in=service_ids).update(service_id=None)


class Command(BaseCommand):

    def handle(self, *args, **options):
        """删除部分美购与日记本的关联"""

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)
        clear_somediarys_service()
        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')

