#!/usr/bin/env python
# -*- coding: utf-8 -*-

import multiprocessing
from django.core.management import BaseCommand

from gm_types.gaia import TOPIC_TYPE

from talos.models.topic.topic import Problem


topic_type_list = [TOPIC_TYPE.ASK, TOPIC_TYPE.SHARE, TOPIC_TYPE.TOPIC]


def _sync_func(topic):

    if not topic.operation_date:
        topic.operation_date = topic.created_time
        topic.save()


class Command(BaseCommand):
    """
    日记贴清洗
    原因: 新加一个字段,用于记录用户设置的术后时间,并以此时间进行展示.
    清洗规则: 老日记贴,将帖子的创建时间 copy 到术后时间字段
    """

    def handle(self, *args, **kwargs):
        print("BEGIN")

        pool = multiprocessing.Pool(processes=4)
        topics = Problem.objects.filter(diary_id__isnull=False, topic_type__in=topic_type_list).iterator()
        for topic in topics:
            pool.apply_async(_sync_func, (topic,))
        pool.close()
        pool.join()

        print("END")
