#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import PLASTICFACESTYLE


class DiaryScanRecord(models.Model):
    class Meta:
        app_label = 'talos'
        db_table = 'api_diary_scan_record'

    diary_id = models.IntegerField(verbose_name=u'日记id', db_index=True)
    before_img = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'术前图')
    after_img = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'术后图')
    nose = models.CharField(max_length=32, default='', verbose_name="术前局部属性-鼻部(宽鼻翼, 窄鼻翼, 标准鼻翼)")
    eye = models.CharField(max_length=32, default='', verbose_name="术前局部属性-眼部(细凤眼, 杏眼, 桃花眼, 小鹿脸, 小狗眼)")
    lib = models.CharField(max_length=32, default='', verbose_name="术前局部属性-唇部(微笑唇, 厚唇, 薄唇, 态度唇)")
    eyebrow = models.CharField(max_length=32, default='', verbose_name="术前局部属性-眉部(一字眉, 野生眉, 粗眉, 柳叶眉, 挑眉)")
    face = models.CharField(max_length=32, default='', verbose_name="术前局部属性-脸部(圆脸型, 鹅蛋脸型, 长型脸型, 钻石脸型, 方脸型, 瓜子脸型, 梨形脸型)")
    gender = models.CharField(max_length=32, default='', verbose_name="术后图片性别")
    age = models.IntegerField(default=0, verbose_name="术后图片年龄")
    template = models.IntegerField(verbose_name=u'内容最新术后图的风格属性(日系风格, 韩系风格, 知性风格)', choices=PLASTICFACESTYLE,
                                     default=PLASTICFACESTYLE.STANDARD)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
