# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from gm_types.gaia import IMAGE_TYPE

from gm_upload import ImgUrlField
from gm_upload import IMG_TYPE

from talos.libs.image_utils import get_w_path
from talos.libs.image_utils import get_thumb_path
from talos.libs.image_utils import get_full_path
from utils.common import convert_image

from .topic import Problem


class TopicImage(models.Model):
    class Meta:
        verbose_name = u'话题图片'
        verbose_name_plural = u'话题图片'
        db_table = 'api_topicimage'
        app_label = 'talos'

    topic = models.ForeignKey(Problem, related_name='images')
    image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'图片地址')
    cover_image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'封面图片地址')
    taken_time = models.DateTimeField(verbose_name=u'拍摄时间', null=True)
    image_type = models.IntegerField(verbose_name=u'图片类型', choices=IMAGE_TYPE, default=IMAGE_TYPE.POST_OPERATION_IMAGE)
    is_cover = models.BooleanField(verbose_name=u'是否封面', default=False)

    @classmethod
    def image_data_format(cls, image_url, cover_image_url):
        if cover_image_url:
            cover_image_url = get_full_path(cover_image_url, '-w')
        else:
            cover_image_url = get_full_path(image_url, '-half')

        image_info = convert_image(image_url, watermark=True)
        image_info.update({
            'cover_image_url': cover_image_url,
            'desc': u'现在',
        })
        return image_info

    def get_image_data(self):
        return self.image_data_format(self.image_url, self.cover_image_url)

    def __unicode__(self):
        return u'<%s><Topic:%s><Image_url: %s>' % (self.id, self.topic, self.image_url)
