# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.services.user import UserService


class VideoWhiteList(models.Model):
    class Meta:
        db_table = 'api_video_white_list'
        app_label = 'talos'

    user_id = models.IntegerField(default=None, db_index=True, verbose_name='用户外键id')

    @property
    def user(self):
        return UserService.get_user_by_user_id(self.user_id)
