"""帖子收藏"""

from django.db import models
from django.utils import timezone


class TractateFavor(models.Model):
    """
    新帖子 收藏相关
    """

    class Meta:
        verbose_name = u'新帖子收藏相关'
        db_table = 'api_tractate_favor'
        app_label = 'talos'
        unique_together = ("user_id", "tractate_id")

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    user_id = models.IntegerField(verbose_name="收藏的用户id")
    is_deleted = models.BooleanField(verbose_name=u"是否取消收藏", default=False)
    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)

    create_time = models.DateTimeField(verbose_name=u"收藏时间", default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u"更新时间", auto_now=True)
