#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.utils import timezone

from gm_types.gaia import (
    REPORT_REASON,
)
from gm_types.mimas import (
    TRACTATE_ID_SOURCE,
    TRACTATE_REPORT_TYPE,
    TRACTATE_REPORT_ACTION,
)


class TractateReport(models.Model):
    """
    新帖子举报相关
    """
    class Meta:
        verbose_name = u'新帖子举报相关'
        db_table = 'api_tractate_report'
        app_label = 'talos'

    user_id = models.IntegerField(verbose_name=u"举报人", db_index=True)
    source_id = models.IntegerField(verbose_name="被举报的id", db_index=True)
    source_status = models.CharField(max_length=12, verbose_name="被举报id类型",
                                     choices=TRACTATE_ID_SOURCE, default=TRACTATE_ID_SOURCE.TRACTATE)
    report_type = models.CharField(max_length=1, verbose_name=u'举报类型',
                                   choices=TRACTATE_REPORT_TYPE, default=TRACTATE_REPORT_TYPE.TRACTATE)
    reason = models.CharField(
        max_length=12, choices=REPORT_REASON, null=False, default=REPORT_REASON.OTHER, verbose_name=u'举报原因')
    action = models.CharField(max_length=12, verbose_name=u'处理动作',
                              choices=TRACTATE_REPORT_ACTION, default=TRACTATE_REPORT_ACTION.UNHANDLED)
    is_handled = models.BooleanField(verbose_name=u'是否已经处理', default=False)
    report_time = models.DateTimeField(verbose_name=u'举报时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
