"""帖子点赞"""

from django.db import models
from django.utils import timezone
from gm_types.gaia import VOTEOBJECT

from talos.services import UserService
from talos.libs.datetime_utils import get_timestamp_or_none


class TractateVote(models.Model):
    """新帖子点赞。"""

    class Meta:
        verbose_name = u'新帖子点赞相关'
        db_table = 'api_tractate_vote'
        app_label = 'talos'
        unique_together = ('user_id', 'tractate_id')

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    user_id = models.IntegerField(verbose_name="用户id")
    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)
    is_fake = models.BooleanField(verbose_name=u"是否是虚拟点赞", default=False)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)

    def to_dict(self):

        data = {
            'tractate_id': self.tractate_id,
            'nickname': "",
            'user_id': self.user_id,
            'content': self.user_id,
            'vote_time': get_timestamp_or_none(self.update_time),
            'membership_level': "",
            'type': VOTEOBJECT.TRACTATE,
            'portrait': "",
        }

        return data


class TractateReplyVote(models.Model):
    """新帖子评论点赞。"""

    class Meta:
        verbose_name = u'新帖子点赞相关'
        db_table = 'api_tractate_reply_vote'
        app_label = 'talos'
        unique_together = ('user_id', 'tractate_id', 'reply_id')

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    user_id = models.IntegerField(verbose_name="用户id")
    reply_id = models.IntegerField(verbose_name="新帖子评论id", db_index=True)
    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)
    is_fake = models.BooleanField(verbose_name=u"是否是虚拟点赞", default=False)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


    def to_dict(self):

        data = {
            'tractate_id': self.tractate_id,
            'reply_id': self.reply_id,
            'nickname': "",
            'user_id': self.user_id,
            'vote_time': get_timestamp_or_none(self.update_time),
            'membership_level': "",
            'type': VOTEOBJECT.TRACTATE_REPLY,
            'portrait': "",
        }

        return data