# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import json
from gm_types.gaia import TAG_TYPE
from talos.logger import info_logger
from utils.rpc import logging_exception
from talos.libs.utils import ObjFromDict
from talos.services.base import ServiceBase
from talos.services.base import RpcServiceModelCache
from talos.cache.service import talos_rpc_service_model_cache


class GoodsService(ServiceBase):
    """美购service."""

    _model_name = 'live_service'
    __cached_layer = RpcServiceModelCache(talos_rpc_service_model_cache, _model_name)

    @classmethod
    def get_service_by_service_id(cls, id):
        if id is None:
            return

        ids = [id]
        result = cls.get_service_by_service_ids(ids)
        if len(result) == 1:
            r = result[0]
            return ObjFromDict(r)   # 为了兼容现有代码,之后需要去掉
        else:
            return None

    @classmethod
    def get_service_doctor_info_by_id(cls, id):
        """get serivce's doctor info.

        return:
            {
                'doctor_id':
                'doctor_user_id':
            }
        """
        if not id:
            return

        s = cls.call_rpc('api/service/doctor_info', service_id=id)
        return s

    @classmethod
    def get_service_by_service_ids(cls, ids):
        if len(ids) == 0:
            return []

        try:
            ids = list(filter(lambda x: x is not None, ids))
            result = cls.call_rpc('api/service/by_ids', ids=ids)
        except Exception:
            return []
        return result

    @classmethod
    def get_diary_detail_related_service_id(cls, service_id, order_id):
        """
        顺序1：关联美购
        如果关联美购下线，取顺序2
        顺序2：关联订单的医生名下同项目tag的美购（在线美购）
        若都没有，此部分不显示
        return: service_id or None
        """
        try:
            online_service_id = cls.call_rpc('api/service/diary_related_online_service_id', service_id=service_id, order_id=order_id)
        except Exception:
            return None
        return online_service_id

    @classmethod
    def get_diary_show_info_by_service_ids(cls, service_ids):
        try:
            result = cls.call_rpc('api/service/get_diary_show_info_by_service_ids', service_ids=service_ids)
        except Exception:
            return {}
        result_dict = {}
        for r in result:
            result_dict[r['id']] = r
        return result_dict

    @classmethod
    def get_services_by_hospital_id(cls, hospital_id, q=None):
        try:
            service_info = cls.call_rpc('api/service/get_service_info_by_hospital', hospital_id=hospital_id, q=q)
        except Exception:
            return []
        return service_info

    @classmethod
    def get_live_service_info_by_id_with_cache(cls, service_id):

        try:
            cached_info = cls.__cached_layer.get(service_id)

            if cached_info:
                v = json.loads(cached_info)
                info_logger.info('美购直播从缓存获取中:{}'.format(service_id))
                return v
        except Exception:
            logging_exception()

        try:
            service_info = cls.call_rpc('api/service/get_service_info_id', service_id=service_id)
            if service_info:
                v = json.dumps(service_info)
                cls.__cached_layer.set(service_id, v, 60 * 60)
        except Exception:
            return {}
        return service_info

    @classmethod
    def get_live_service_info_by_id(cls, service_id):
        try:
            service_info = cls.call_rpc('api/service/get_service_info_id', service_id=service_id)
        except Exception:
            return {}
        return service_info

    @classmethod
    def get_live_service_info_by_ids(cls, service_ids):
        return cls.call_rpc('api/service/list_by_ids', service_ids=service_ids)

    @classmethod
    def get_service_project_tags_by_ids(cls, service_ids):
        try:
            result = cls.call_rpc('api/service/get_service_tags_by_ids', service_ids=service_ids)
        except Exception:
            return {}
        result_dict = {}
        for r in result:
            result_dict[r['id']] = r
        return result_dict

    @classmethod
    def get_tag_data(cls, tags):
        if not tags:
            return {}

        tags = sorted(tags, key=lambda x: x.id)
        tag_data = [x for x in tags if x.tag_type == TAG_TYPE.BODY_PART]

        if not tag_data:
            tag_data = [x for x in tags if x.tag_type == TAG_TYPE.BODY_PART_SUB_ITEM]
        if not tag_data:
            tag_data = [x for x in tags if x.tag_type == TAG_TYPE.ITEM_WIKI]
        if not tag_data:
            tag_data = tags
        tag = tag_data[0]

        return {
            'tag_id': tag.id,
            'tag_name': tag.name
        }

    @classmethod
    def get_service_item_info_by_order_ids(cls, order_ids):
        if not order_ids:
            return {}
        try:
            result = cls.call_rpc("api/service/get_service_item_info_by_order_ids", order_ids=order_ids)
        except Exception as e:
            return {}

        return result
