# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from gm_types.gaia import AGILE_TAG_ATTRIBUTE

from talos.services.models.base import ServiceModelBase


class Tag(ServiceModelBase):
    """tag object.

    :properties:
        id
        name
        tag_type
    """

    __slots__ = ['id', 'name', 'tag_type', ]

    def __init__(self, id, name, tag_type):
        self.id = int(id)
        self.name = name
        self.tag_type = tag_type


class TagType(ServiceModelBase):
    """tag object.

    :properties:
        id
        name
        tag_type
        recommend_type

    """
    __slots__ = ['id', 'name', 'tag_type', 'recommend_type']

    def __init__(self, id, name, tag_type, recommend_type):
        self.id = int(id)
        self.name = name
        self.tag_type = tag_type
        self.recommend_type =recommend_type


class AgileTag(ServiceModelBase):
    """
    tag object
    """
    __slots__ = [
        'id',
        'name',
        'tags_type',
        "recommends_type",
        'attribute',  # 标签属性
    ]

    _auto_type_map_ = [
        ('name', str, u''),
        ('tags_type', list, []),
        ('recommends_type', list, []),
        ('attribute', str, AGILE_TAG_ATTRIBUTE.NULL)
    ]

    def __init__(self, id, name, tags_type=[], recommends_type=[], attribute=AGILE_TAG_ATTRIBUTE.NULL):
        self.id = int(id)
        self.name = name
        self.tags_type = tags_type
        self.recommends_type = recommends_type
        self.attribute = attribute


class TagV3(ServiceModelBase):
    """
        tagv3 object
        """
    __slots__ = [
        'id',
        'name',
        'tag_type',
    ]

    def __init__(self, id, name, tag_type):
        self.id = int(id)
        self.name = name
        self.tag_type = tag_type
