# coding:utf-8

import json

from celery import shared_task

from talos.views.diary.sitemap import diaries_sitemap, mip_diaries_sitemap
from talos.models.sitemap import SiteMap
from talos.views.topic.sitemap import get_article_html_sitemap, get_topic_html_sitemap
from qa.views.sitemap import get_mip_answer_sitemap
from utils.rpc import rpc_client


@shared_task
def sitemap():

    page_num = 5000

    diaries = []
    for content_level in [5, 4, 3]:
        diaries.extend(diaries_sitemap(content_level=content_level))

    mip_diaries = []
    for content_level in [5, 4, 3]:
        mip_diaries.extend(mip_diaries_sitemap(content_level=content_level))

    services = []
    for rating in [5, 4, 3]:
        try:
            services.extend(rpc_client['api/service/sitemap/html'](rating=rating, count=10000).unwrap())
        except:
            pass

    topics = get_topic_html_sitemap()
    articles = get_article_html_sitemap()
    answers = get_mip_answer_sitemap()

    ship_data = diaries + topics + services + articles + answers + mip_diaries
    page = 0
    for i in range(0, len(ship_data), page_num):
        contents = ship_data[i: i+page_num]
        site_map, _ = SiteMap.objects.get_or_create(site_type="ship", page_num=page)
        site_map.data = json.dumps(contents)
        site_map.save()
        page += 1

    del ship_data
    del articles
    del answers
    del mip_diaries

    flag_ship_data = diaries + topics + services
    page = 0
    for i in range(0, len(flag_ship_data), page_num):
        contents = flag_ship_data[i: i+page_num]
        site_map, _ = SiteMap.objects.get_or_create(site_type="flag_ship", page_num=page)
        site_map.data = json.dumps(contents)
        site_map.save()
        page += 1

