# -*- coding: UTF-8 -*-
from talos.services import UserService, HospitalService


class HospitalTool(object):
    # 特殊账号 所长大人
    __special_doctor = 22

    @staticmethod
    def get_hospital_id(user_id):
        hospital = UserService.get_doctor_hospital_id_by_user_id(user_id)
        hospital_id = hospital['hospital_id']
        if hospital_id is not None:
            return hospital_id
        doctor_id = hospital['doctor_id']
        if doctor_id is not None:
            hospital_info = HospitalService.get_hospital_from_doctor_id(hospital['doctor_id'])
            if hospital_info:
                hospital_id = hospital_info.id
        return hospital_id

    @classmethod
    def in_one_hospital(cls, topic, reply_user_id):
        if topic.user_id == reply_user_id:
            return True

        target_hospital_id = HospitalTool.get_hospital_id(reply_user_id)

        if target_hospital_id is None:
            return True

        user_info_list = UserService.get_users_by_user_ids([reply_user_id, topic.user_id])
        reply_info = user_info_list.get(reply_user_id)
        topic_info = user_info_list.get(topic.user_id)

        if reply_user_id == cls.__special_doctor or reply_info.is_puppet:
            return True
        elif topic.user_id == cls.__special_doctor or topic_info.is_puppet:
            return False

        doctor_hospital_id = topic.diary.hospital_id if topic.diary_id else None

        if doctor_hospital_id and target_hospital_id == doctor_hospital_id:
            return True
        return False
